% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconciliation.R
\name{reconcile}
\alias{reconcile}
\alias{reconcile.mdl_df}
\title{Forecast reconciliation}
\usage{
reconcile(.data, ...)

\method{reconcile}{mdl_df}(.data, ...)
}
\arguments{
\item{.data}{A mable.}

\item{...}{Reconciliation methods applied to model columns within \code{.data}.}
}
\description{
This function allows you to specify the method used to reconcile forecasts
in accordance with its key structure.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fable)
lung_deaths_agg <- as_tsibble(cbind(mdeaths, fdeaths)) \%>\%
  aggregate_key(key, value = sum(value))

lung_deaths_agg \%>\%
  model(lm = TSLM(value ~ trend() + season())) \%>\%
  reconcile(lm = min_trace(lm)) \%>\% 
  forecast()
\dontshow{\}) # examplesIf}
}
