% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_pbi_dax_query.R
\name{fabric_pbi_dax_query}
\alias{fabric_pbi_dax_query}
\title{Query a Microsoft Fabric/Power Bi semantic model with DAX}
\usage{
fabric_pbi_dax_query(
  connstr,
  dax,
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID", unset =
    "04b07795-8ddb-461a-bbee-02f9e1bf7b46"),
  include_nulls = TRUE,
  api_base = "https://api.powerbi.com/v1.0/myorg"
)
}
\arguments{
\item{connstr}{Character. Power BI connection string, e.g.
\code{"Data Source=powerbi://api.powerbi.com/v1.0/myorg/Workspace;Initial Catalog=Dataset;"}.
The function accepts either \verb{Data Source=} and \verb{Initial Catalog=} parts, or a
bare \verb{powerbi://...} for the data source plus a \verb{Dataset=}/\verb{Catalog=}/\verb{Initial Catalog=} key
(see details).}

\item{dax}{Character scalar with a valid DAX query (see example).}

\item{tenant_id}{Microsoft Azure tenant ID. Defaults to \code{Sys.getenv("FABRICQUERYR_TENANT_ID")} if missing.}

\item{client_id}{Microsoft Azure application (client) ID used to authenticate. Defaults to
\code{Sys.getenv("FABRICQUERYR_CLIENT_ID")}. You may be able to use the Azure CLI app id
\code{"04b07795-8ddb-461a-bbee-02f9e1bf7b46"}, but may want to make your own
app registration in your tenant for better control.}

\item{include_nulls}{Logical; pass-through to the REST serializer setting. Defaults to TRUE.
If TRUE, null values are included in the response; if FALSE, they are omitted.}

\item{api_base}{API base URL. Defaults to "https://api.powerbi.com/v1.0/myorg".
'myorg' is appropriate for most use cases and does not necessarily need to be changed.}
}
\value{
A tibble with the query result (0 rows if the DAX query returned no rows).
}
\description{
High-level helper that authenticates against Azure AD, resolves the
workspace & dataset from a Power BI (Microsoft Fabric) XMLA/connection string, executes a DAX
statement via the Power BI REST API, and returns a tibble with
the resulting data.
}
\details{
\itemize{
\item In Microsoft Fabric/Power BI, you can find and copy the connection string by going to
a 'Semantic model' item, then go to 'File' -> 'Settings' -> 'Server settings'.
Ensure that the account you use to authenticate has access to the workspace,
or has been granted 'Build' permissions on the dataset (via sharing).
\item \pkg{AzureAuth} is used to acquire the token. Be wary of
caching behavior; you may want to call \code{\link[AzureAuth:get_azure_token]{AzureAuth::clean_token_directory()}}
to clear cached tokens if you run into issues
}
}
\examples{
# Example is not executed since it requires configured credentials for Fabric
\dontrun{
conn <- "Data Source=powerbi://api.powerbi.com/v1.0/myorg/My Workspace;Initial Catalog=SalesModel;"
df <- fabric_pbi_dax_query(
  connstr = conn,
  dax = "EVALUATE TOPN(1000, 'Customers')",
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID")
)
dplyr::glimpse(df)
}
}
