% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_multivariate.R
\name{draw_multivariate}
\alias{draw_multivariate}
\title{Draw multivariate random variables}
\usage{
draw_multivariate(formula, sep = "_")
}
\arguments{
\item{formula}{Formula describing the multivariate draw. The lefthand side is the names or prefix and the right-hand side is the multivariate draw function call, such as mvrnorm from the MASS library or rmnom from the extraDistr library.}

\item{sep}{Separator string between prefix and variable number. Only used when a single character string is provided and multiple variables created.}
}
\value{
tibble
}
\description{
Draw multivariate random variables
}
\examples{

library(MASS)

# draw from multivariate normal distribution
draw_multivariate(c(Y_1, Y_2) ~ mvrnorm(
  n = 5,
  mu = c(0, 0),
  Sigma = matrix(c(10, 3, 3, 2), 2, 2)
))

# equivalently, you can provide a prefix for the variable names
# (easier if you have many variables)
draw_multivariate(Y ~ mvrnorm(
  n = 5,
  mu = c(0, 0),
  Sigma = matrix(c(10, 3, 3, 2), 2, 2)
))

# within fabricate
fabricate(
  N = 100,
  draw_multivariate(c(Y_1, Y_2) ~ mvrnorm(
    n = N,
    mu = c(0, 0),
    Sigma = matrix(c(10, 3, 3, 2), 2, 2)
  ))
)

# You can also write the following, which works but gives less control over the names
fabricate(N = 100,
Y = mvrnorm(
  n = N,
  mu = c(0, 0),
  Sigma = matrix(c(10, 3, 3, 2), 2, 2)
))

}
