% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac2x2analyze.R
\name{fac2x2analyze}
\alias{fac2x2analyze}
\title{Significance testing for the 2/3-1/3, 1/3-1/3-1/3, 1/2-1/2 procedures}
\usage{
fac2x2analyze(time, event, indA, indB, covmat, alpha, dig = 2,
  niter = 5)
}
\arguments{
\item{time}{follow-up times}

\item{event}{event indicators (0/1)}

\item{indA}{treatment A indicators (0/1)}

\item{indB}{treatment B indicators (0/1)}

\item{covmat}{covariate matrix, must be non-NULL.  Factor variables MUST use 0/1 dummy variables}

\item{alpha}{two-sided familywise significance level}

\item{dig}{number of decimal places to which we \code{\link{roundDown}} the critical value}

\item{niter}{number of interations passed to \code{crit2x2} function call}
}
\value{
\item{loghrA }{overall A log hazard ratio}

\item{seA }{standard error of the overall A log hazard ratio}

\item{ZstatA }{Z-statistic for the overall A log hazard ratio}

\item{pvalA }{two-sided p-value for the overall hazard ratio}

\item{hrA }{overall A hazard ratio}

\item{ciA }{95\% confidence interval for the overall A hazard ratio}

\item{loghra }{simple A log hazard ratio}

\item{sea }{standard error of the simple A log hazard ratio}

\item{Zstata }{Z-statistic for the simple A log hazard ratio}

\item{pvala }{two-sided p-value for the simple A hazard ratio}

\item{hra }{simple A hazard ratio}

\item{cia }{95\% confidence interval for the simple A hazard ratio}

\item{loghrab }{simple AB log hazard ratio}

\item{seab}{standard error of the simple AB log hazard ratio}

\item{Zstatab }{Z-statistic for the simple AB log hazard ratio}

\item{pvalab }{two-sided p-value for the simple AB hazard ratio}

\item{hrab }{simple AB hazard ratio}

\item{ciab}{95\% confidence interval for the simple AB hazard ratio}

\item{crit23A }{2/3-1/3 procedure's critical value for the overall A statistic}

\item{sig23A }{2/3-1/3 procedure's p-value rejection criterion for the overall A null hypothesis}

\item{crit23ab}{2/3-1/3 procedure's critical value for the simple AB statistic}

\item{sig23ab }{2/3-1/3 procedure's p-value rejection criterion for the simple A null hypothesis}

\item{result23 }{2/3-1/3 procedure's accept/reject decisions for the overall A and simple A null hypotheses results}

\item{crit13 }{1/3-1/3-1/3 procedure's critical value for all three test statistics}

\item{sig13 }{1/3-1/3-1/3 procedure's p-value rejection criterion for the overall A, simple A, and simple AB null hypotheses}

\item{result13 }{1/3-1/3-1/3 procedure's accept/reject decisions for the overall A, simple A, and simple AB null hypotheses results}

\item{crit12 }{1/2-1/2 procedure's critical value for the simple A and AB statistics}

\item{sig12 }{1/2-1/2 procedure's p-value rejection criterion for the simple A and simple AB null hypotheses}

\item{result12 }{1/2-1/2 procedure's accept/reject decisions for the simple A and simple AB null hypotheses results}

\item{corAa }{correlation between the overall A and simple A Wald statistics}

\item{corAab }{correlation between the overall A and simple AB Wald statistics}

\item{coraab }{correlation between the simple A and simple AB Wald statistics}
}
\description{
Performs significance testing for the 2/3-1/3, 1/3-1/3-1/3, 1/2-1/2 procedures.
Also reports the hazard ratios, 95\% confidence intervals, p-values,
nominal significance levels, and correlations for the overall A,
simple A, and simple AB test statistics.
}
\examples{
 # First load the simulated data variables. The "simdat" file is
 # a 100-by-9 matrix which is loaded with the factorial2x2 package.
 time <- simdat[, "time"]
 event <- simdat[, "event"]
 indA <- simdat[, "indA"]
 indB <- simdat[, "indB"]
 covmat <- simdat[, 6:10]
 fac2x2analyze(time, event, indA, indB, covmat, alpha = 0.05, niter = 5)
#  $loghrA
# [1] 0.05613844

# $seA
# [1] 0.4531521

# $ZstatA
# [1] 0.1238843

# $pvalA
# [1] 0.9014069

# $hrA
# [1] 1.057744

# $ciA
# [1] 0.4351608 2.5710556

# $loghra
# [1] 0.1987329

# $sea
# [1] 0.6805458

# $Zstata
# [1] 0.2920198

# $pvala
# [1] 0.7702714

# $hra
# [1] 1.219856

# $cia
# [1] 0.3213781 4.6302116

# $loghrab
# [1] 0.2864932

# $seab
# [1] 0.6762458

# $Zstatab
# [1] 0.4236525

# $pvalab
# [1] 0.6718193

# $hrab
# [1] 1.331749

# $ciab
# [1] 0.3538265 5.0125010

# $crit23A
# [1] -2.129

# $sig23A
# [1] 0.03325426

# $crit23ab
# [1] -2.299

# $sig23ab
# [1] 0.02150494

# $result23
# [1] "accept overall A" "accept simple AB"

# $crit13
# [1] -2.338

# $sig13
# [1] 0.01938725

# $result13
# [1] "accept overall A" "accept simple A"  "accept simple AB"

# $crit12
# [1] -2.216

# $sig12
# [1] 0.0266915

# $result12
# [1] "accept simple A"  "accept simple AB"

# $corAa
# [1] 0.6123399

# $corAab
# [1] 0.5675396

# $coraab
# [1] 0.4642737
}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. (2019). Submitted.
}
\author{
Eric Leifer, James Troendle
}
