% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{paratraceplot}
\alias{paratraceplot}
\alias{paratraceplot.fsvdraws}
\title{Trace plots of parameter draws.}
\usage{
\method{paratraceplot}{fsvdraws}(x, fsvsimobj = NULL, thinning = NULL, maxrows = 3, ...)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{fsvsimobj}{To indicate data generating values in case of simulated
data, pass an object of type \code{fsvsim} (usually the result of a
call to \code{\link{fsvsim}}).}

\item{thinning}{Plot every \code{thinning}th draw.}

\item{maxrows}{Indicates the maximum number of rows to be drawn per page.}

\item{...}{Ignored.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{paratraceplot} draws trace plots of all parameters (\code{mu, phi,
sigma}). Can be an important tool to check MCMC convergence if inference
about (certain) parameters is sought.
}
\seealso{
Other plotting: 
\code{\link{comtimeplot}()},
\code{\link{corimageplot}()},
\code{\link{corplot}()},
\code{\link{cortimeplot}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{facloadtraceplot}()},
\code{\link{logvartimeplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()},
\code{\link{voltimeplot}()}
}
\concept{plotting}
