% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{orderident}
\alias{orderident}
\title{A posteriori factor order identification}
\usage{
orderident(x, method = "summed")
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{method}{Methods currently supported:
\itemize{
\item \code{summean} Sort by sum of mean loadings (descending).
\item \code{summeaninv} Sort by sum of mean loadings (ascending).
\item \code{summeanabs} Sort by sum of mean absolute loadings (descending).
\item \code{summed} Sort by sum of median loadings (descending).
\item \code{summedinv} Sort by sum of median loadings (ascending).
\item \code{summedabs} Sort by sum of median absolute loadings (descending).
\item \code{maxmed} Sort by maximum median loadings (descending).
\item \code{maxmedinv} Sort by maximum median loadings (ascending).
\item \code{maxmedrel} Sort by maximum median loadings, relative to the sum of all median loadings on that factor (descending).
\item \code{maxmedabsrel} Sort by maximum absolute median loadings, relative to the sum of all median loadings on that factor (descending).
}}
}
\value{
Returns an object of class \code{'fsvdraws'} with adjusted
ordering.
}
\description{
\code{orderident} provides some (very ad-hoc) methods for identifying
the ordering of the factors after running the (unrestricted) MCMC
sampler by 
ordering according to the argument \code{method}.
}
\seealso{
Other postprocessing: \code{\link{signident}}
}

