# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Calculation
#' @description Calculation Class
#' @format An \code{R6Class} generator object
#' @field pa  named list( \link{PACalculationParameters} ) [optional]
#'
#' @field spar  named list( \link{SPARCalculationParameters} ) [optional]
#'
#' @field vault  named list( \link{VaultCalculationParameters} ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Calculation <- R6::R6Class(
  'Calculation',
  public = list(
    `pa` = NULL,
    `spar` = NULL,
    `vault` = NULL,
    initialize = function(`pa`=NULL, `spar`=NULL, `vault`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`pa`)) {
        stopifnot(is.vector(`pa`), length(`pa`) != 0)
        sapply(`pa`, function(x) stopifnot(R6::is.R6(x)))
        self$`pa` <- `pa`
      }
      if (!is.null(`spar`)) {
        stopifnot(is.vector(`spar`), length(`spar`) != 0)
        sapply(`spar`, function(x) stopifnot(R6::is.R6(x)))
        self$`spar` <- `spar`
      }
      if (!is.null(`vault`)) {
        stopifnot(is.vector(`vault`), length(`vault`) != 0)
        sapply(`vault`, function(x) stopifnot(R6::is.R6(x)))
        self$`vault` <- `vault`
      }
    },
    toJSON = function() {
      CalculationObject <- list()
      if (!is.null(self$`pa`)) {
        CalculationObject[['pa']] <-
          lapply(self$`pa`, function(x) x$toJSON())
      }
      if (!is.null(self$`spar`)) {
        CalculationObject[['spar']] <-
          lapply(self$`spar`, function(x) x$toJSON())
      }
      if (!is.null(self$`vault`)) {
        CalculationObject[['vault']] <-
          lapply(self$`vault`, function(x) x$toJSON())
      }

      CalculationObject
    },
    fromJSON = function(CalculationJson) {
      CalculationObject <- jsonlite::fromJSON(CalculationJson)
      if (!is.null(CalculationObject$`pa`)) {
        self$`pa` <- ApiClient$new()$deserializeObj(CalculationObject$`pa`, "map(PACalculationParameters)", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(CalculationObject$`spar`)) {
        self$`spar` <- ApiClient$new()$deserializeObj(CalculationObject$`spar`, "map(SPARCalculationParameters)", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(CalculationObject$`vault`)) {
        self$`vault` <- ApiClient$new()$deserializeObj(CalculationObject$`vault`, "map(VaultCalculationParameters)", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`pa`)) {
        sprintf(
        '"pa":
        %s
',
        jsonlite::toJSON(lapply(self$`pa`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )},
        if (!is.null(self$`spar`)) {
        sprintf(
        '"spar":
        %s
',
        jsonlite::toJSON(lapply(self$`spar`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )},
        if (!is.null(self$`vault`)) {
        sprintf(
        '"vault":
        %s
',
        jsonlite::toJSON(lapply(self$`vault`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(CalculationJson) {
      CalculationObject <- jsonlite::fromJSON(CalculationJson)
      self$`pa` <- ApiClient$new()$deserializeObj(CalculationObject$`pa`, "map(PACalculationParameters)", loadNamespace("factset.analyticsapi.engines"))
      self$`spar` <- ApiClient$new()$deserializeObj(CalculationObject$`spar`, "map(SPARCalculationParameters)", loadNamespace("factset.analyticsapi.engines"))
      self$`vault` <- ApiClient$new()$deserializeObj(CalculationObject$`vault`, "map(VaultCalculationParameters)", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
