# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Calculations operations
#' @description factset.analyticsapi.engines.Calculations
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ CancelCalculationById } \emph{ Cancel calculation by id }
#' This is the endpoint to cancel a previously submitted calculation request.  Instead of doing a GET on the getCalculationById URL, cancel the calculation by doing a DELETE.  All individual calculation units within the calculation will be canceled if they have not already finished.
#'
#' \itemize{
#' \item \emph{ @param } id character
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 204 | Expected response, request was cancelled successfully.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid identifier provided.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | There was no request for the identifier provided, or the request was already canceled for the provided identifier.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetCalculationStatusById } \emph{ Get calculation status by id }
#' This is the endpoint to check on the progress of a previous calculation request.  Response body contains status information of the entire request and each individual calculation unit.
#'
#' \itemize{
#' \item \emph{ @param } id character
#' \item \emph{ @returnType } \link{CalculationStatus} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns status information of the entire calculation and each individual calculation unit.
#'
#' \item return type : CalculationStatus 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid identifier provided.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Provided identifier was not a request, or the request was cancelled.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' Cache-Control \tab Standard HTTP header. Header will specify max-age in seconds. Polling can be adjusted based on the max-age value. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetCalculationStatusSummaries } \emph{ Get all calculation statuses }
#' This endpoints returns all active calculation requests.
#'
#' \itemize{
#' \item \emph{ @returnType } named list( \link{CalculationStatusSummary} ) \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | List of active calculation requests.
#'
#' \item return type : map(CalculationStatusSummary) 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ RunCalculation } \emph{ Run calculation }
#' This endpoint creates a new calculation and runs the set of calculation units specified in the POST body.  This must be used first before get status or cancelling endpoints with a calculation id.   A successful response will contain the URL to check the status of the calculation request.    Remarks:  * Maximum 25 points allowed per calculation and maximum 500 points allowed across all simultaneous calculations. (Refer API documentation for more information)                * Any settings in POST body will act as a one-time override over the settings saved in the PA/SPAR/Vault template.
#'
#' \itemize{
#' \item \emph{ @param } calculation \link{Calculation}
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 202 | Expected response, contains the URL in the Location header to check the status of the calculation.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid POST body.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 415 | Missing/Invalid Content-Type header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 429 | Rate limit reached. Cancel older requests using Cancel Calculation endpoint or wait for older requests to finish / expire.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-FactSet-Api-Points-Limit \tab Maximum points limit across all batches. \cr
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-FactSet-Api-Points-Remaining \tab Number of points remaining till points limit reached. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Location \tab URL to check status of the request. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  CancelCalculationById  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.id <- 'id_example' # character | From url, provided from the location header in the Run Multiple Calculations endpoint.
#'
#' #Cancel calculation by id
#' api.instance <- CalculationsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$CancelCalculationById(var.id),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetCalculationStatusById  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.id <- 'id_example' # character | From url, provided from the location header in the Run Multiple Calculations endpoint.
#'
#' #Get calculation status by id
#' api.instance <- CalculationsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetCalculationStatusById(var.id),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetCalculationStatusSummaries  ####################
#'
#' library(factset.analyticsapi.engines)
#'
#' #Get all calculation statuses
#' api.instance <- CalculationsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetCalculationStatusSummaries(),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  RunCalculation  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.calculation <- Calculation$new() # Calculation | 
#'
#' #Run calculation
#' api.instance <- CalculationsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$RunCalculation(calculation=var.calculation),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @importFrom rlang abort
#' @export
CalculationsApi <- R6::R6Class(
  'CalculationsApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    CancelCalculationById = function(id, ...){
      apiResponse <- self$CancelCalculationByIdWithHttpInfo(id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    CancelCalculationByIdWithHttpInfo = function(id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`id`)) {
        rlang::abort(message = "Missing required parameter `id`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `id`."))
      }

      urlPath <- "/analytics/engines/v2/calculations/{id}"
      if (!missing(`id`)) {
        urlPath <- gsub(paste0("\\{", "id", "\\}"), URLencode(as.character(`id`), reserved = TRUE), urlPath)
      }

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "DELETE",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetCalculationStatusById = function(id, ...){
      apiResponse <- self$GetCalculationStatusByIdWithHttpInfo(id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetCalculationStatusByIdWithHttpInfo = function(id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`id`)) {
        rlang::abort(message = "Missing required parameter `id`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `id`."))
      }

      urlPath <- "/analytics/engines/v2/calculations/{id}"
      if (!missing(`id`)) {
        urlPath <- gsub(paste0("\\{", "id", "\\}"), URLencode(as.character(`id`), reserved = TRUE), urlPath)
      }

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "CalculationStatus", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetCalculationStatusSummaries = function(...){
      apiResponse <- self$GetCalculationStatusSummariesWithHttpInfo(...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetCalculationStatusSummariesWithHttpInfo = function(...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      urlPath <- "/analytics/engines/v2/calculations"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(CalculationStatusSummary)", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    RunCalculation = function(calculation=NULL, ...){
      apiResponse <- self$RunCalculationWithHttpInfo(calculation, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    RunCalculationWithHttpInfo = function(calculation=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (!missing(`calculation`)) {
        body <- `calculation`$toJSONString()
      } else {
        body <- NULL
      }

      urlPath <- "/analytics/engines/v2/calculations"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "POST",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        ApiResponse$new(NULL, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    }
  )
)
