# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title SPARDateParameters
#' @description SPARDateParameters Class
#' @format An \code{R6Class} generator object
#' @field startdate  character 
#'
#' @field enddate  character 
#'
#' @field frequency  character 
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
SPARDateParameters <- R6::R6Class(
  'SPARDateParameters',
  public = list(
    `startdate` = NULL,
    `enddate` = NULL,
    `frequency` = NULL,
    initialize = function(`startdate`, `enddate`, `frequency`, ...){
      local.optional.var <- list(...)
      if (!missing(`startdate`)) {
        stopifnot(is.character(`startdate`), length(`startdate`) == 1)
        self$`startdate` <- `startdate`
      }
      if (!missing(`enddate`)) {
        stopifnot(is.character(`enddate`), length(`enddate`) == 1)
        self$`enddate` <- `enddate`
      }
      if (!missing(`frequency`)) {
        stopifnot(is.character(`frequency`), length(`frequency`) == 1)
        self$`frequency` <- `frequency`
      }
    },
    toJSON = function() {
      SPARDateParametersObject <- list()
      if (!is.null(self$`startdate`)) {
        SPARDateParametersObject[['startdate']] <-
          self$`startdate`
      }
      if (!is.null(self$`enddate`)) {
        SPARDateParametersObject[['enddate']] <-
          self$`enddate`
      }
      if (!is.null(self$`frequency`)) {
        SPARDateParametersObject[['frequency']] <-
          self$`frequency`
      }

      SPARDateParametersObject
    },
    fromJSON = function(SPARDateParametersJson) {
      SPARDateParametersObject <- jsonlite::fromJSON(SPARDateParametersJson)
      if (!is.null(SPARDateParametersObject$`startdate`)) {
        self$`startdate` <- SPARDateParametersObject$`startdate`
      }
      if (!is.null(SPARDateParametersObject$`enddate`)) {
        self$`enddate` <- SPARDateParametersObject$`enddate`
      }
      if (!is.null(SPARDateParametersObject$`frequency`)) {
        self$`frequency` <- SPARDateParametersObject$`frequency`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`startdate`)) {
        sprintf(
        '"startdate":
          "%s"
                ',
        self$`startdate`
        )},
        if (!is.null(self$`enddate`)) {
        sprintf(
        '"enddate":
          "%s"
                ',
        self$`enddate`
        )},
        if (!is.null(self$`frequency`)) {
        sprintf(
        '"frequency":
          "%s"
                ',
        self$`frequency`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(SPARDateParametersJson) {
      SPARDateParametersObject <- jsonlite::fromJSON(SPARDateParametersJson)
      self$`startdate` <- SPARDateParametersObject$`startdate`
      self$`enddate` <- SPARDateParametersObject$`enddate`
      self$`frequency` <- SPARDateParametersObject$`frequency`
      self
    }
  )
)
