% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{fairTwins}
\alias{fairTwins}
\title{Fair Twin Inspection convenience function.}
\usage{
fairTwins(x, train.id = seq_len(nrow(x$train)), test.id = NULL, cols = NULL)
}
\arguments{
\item{x}{Object of class \code{fairadapt}, a result of an adaptation
procedure.}

\item{train.id}{A vector of indices specifying which rows of the training
data should be displayed.}

\item{test.id}{A vector of indices specifying which rows of the test
data should be displayed.}

\item{cols}{A \code{character} vector, subset of \code{names(train.data)},
which specifies which subset of columns is to be displayed in the result.}
}
\value{
A \code{data.frame}, containing the original and adapted values
of the requested individuals. Adapted columns have \verb{_adapted} appended
to their original name.
}
\description{
Fair Twin Inspection convenience function.
}
\examples{
n_samp <- 200
uni_dim <- c(       "gender", "edu", "test", "score")
uni_adj <- matrix(c(       0,     1,      1,       0,
                           0,     0,      1,       1,
                           0,     0,      0,       1,
                           0,     0,      0,       0),
                  ncol = length(uni_dim),
                  dimnames = rep(list(uni_dim), 2),
                  byrow = TRUE)

uni_ada <- fairadapt(score ~ .,
  train.data = head(uni_admission, n = n_samp),
  test.data = tail(uni_admission, n = n_samp),
  adj.mat = uni_adj,
  prot.attr = "gender"
)

fairTwins(uni_ada, train.id = 1:5)
}
