% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{fairadaptBoot}
\alias{fairadaptBoot}
\title{Fairadapt Boostrap wrapper}
\usage{
fairadaptBoot(
  formula,
  prot.attr,
  adj.mat,
  train.data,
  test.data = NULL,
  cfd.mat = NULL,
  top.ord = NULL,
  res.vars = NULL,
  quant.method = rangerQuants,
  keep.object = FALSE,
  n.boot = 100,
  rand.mode = c("finsamp", "quant", "both"),
  test.seed = 2022,
  ...
)
}
\arguments{
\item{formula}{Object of class \code{formula} describing the response and
the covariates.}

\item{prot.attr}{A value of class \code{character} describing the binary
protected attribute. Must be one of the entries of \code{colnames(adj.mat)}.}

\item{adj.mat}{Matrix of class \code{matrix} encoding the relationships in
the causal graph. \code{M[i,j] == 1L} implies the existence of an edge from
node i to node j. Must include all the variables appearing in the formula
object. When the \code{adj.mat} argument is set to \code{NULL}, then the
\code{top.ord} argument has to be supplied.}

\item{train.data, test.data}{Training data & testing data, both of class
\code{data.frame}. Test data is by default \code{NULL}.}

\item{cfd.mat}{Symmetric matrix of class \code{matrix} encoding the
bidirected edges in the causal graph. \verb{M[i,j] == M[j, i] == 1L}
implies the existence of a bidirected edge between nodes i and j. Must
include all the variables appearing in the formula object.}

\item{top.ord}{A vector of class \code{character} describing the
topological ordering of the causal graph. Default value is \code{NULL},
but this argument must be supplied if \code{adj.mat} is not specified.
Also must include all the variables appearing in the formula object.}

\item{res.vars}{A vector of class \code{character} listing all the resolving
variables, which should not be changed by the adaption procedure. Default
value is \code{NULL}, corresponding to no resolving variables. Resolving
variables should be a subset of the descendants of the protected attribute.}

\item{quant.method}{A function choosing the method used for quantile
regression. Default value is \code{rangerQuants} (using random forest
quantile regression). Other implemented options are \code{linearQuants} and
\code{mcqrnnQuants}. A custom function can be supplied by the user here,
and the associated method for the S3 generic \code{computeQuants} needs to be
added.}

\item{keep.object}{a \code{logical} scalar, indicating whether all the
\code{fairadapt} S3 objects built in bootstrap repetitions should be saved.}

\item{n.boot}{An integer corresponding to the umber of bootstrap iterations.}

\item{rand.mode}{A string, taking values \code{"finsamp"}, \code{"quant"} or \code{"both"},
corresponding to considering finite sample uncertainty, quantile
uncertainty, or both.}

\item{test.seed}{a seed for the randomness in breaking quantiles for the
discrete variables. This argument is only relevant when \code{rand.mode} equals
\code{"quant"} or \code{"both"} (otherwise ignored).}

\item{...}{Additional arguments forwarded to the function passed as
\code{quant.method}.}
}
\value{
An object of class \code{fairadaptBoot}, containing the original and
adapted training and testing data, together with the causal graph and some
additional meta-information.
}
\description{
The \code{fairadapt()} function performs data adaptation, but does so only
once. Sometimes, it might be desirable to repeat this process, in order to be
able to make uncertainty estimates about the data adaptation that is
performed. The wrapper function \code{fairadaptBoot()} enables the user to do
so, by performing the \code{fairadapt()} procedure multiple times, and
keeping in memory the important multiple data transformations. For a worked
example of how to use \code{fairadaptBoot()} for uncertainty quantification,
see the \code{fairadapt} vignette.
}
\examples{
n_samp <- 200
uni_dim <- c(       "gender", "edu", "test", "score")
uni_adj <- matrix(c(       0,     1,      1,       0,
                           0,     0,      1,       1,
                           0,     0,      0,       1,
                           0,     0,      0,       0),
                  ncol = length(uni_dim),
                  dimnames = rep(list(uni_dim), 2),
                  byrow = TRUE)

uni_ada <- fairadaptBoot(score ~ .,
  train.data = head(uni_admission, n = n_samp),
  test.data = tail(uni_admission, n = n_samp),
  adj.mat = uni_adj,
  prot.attr = "gender",
  n.boot = 5
)

uni_ada

}
\references{
Plecko, D. & Meinshausen, N. (2019).
Fair Data Adaptation with Quantile Preservation
}
