% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{plot.roc_curve}
\alias{plot.roc_curve}
\title{Receiver Operating Characteristic (ROC) curve}
\usage{
\method{plot}{roc_curve}(x, add = FALSE, ...)
}
\arguments{
\item{x}{output of \code{\link{ROC}}.}

\item{add}{logical indicating if the curve should be added to the current
plot.}

\item{...}{additional plotting arguments (see \code{\link[graphics]{par}}).}
}
\value{
A base plot.
}
\description{
Plots the True Positive Rate (TPR) as a function of the False Positive Rate
(FPR) for different thresholds in predicted probabilities.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateRegression(
  n = 500, pk = 20,
  family = "binomial", ev_xy = 0.8
)

# Logistic regression
fitted <- glm(simul$ydata ~ simul$xdata, family = "binomial")$fitted.values

# Constructing the ROC curve
roc <- ROC(predicted = fitted, observed = simul$ydata)
plot(roc)
}
}
\seealso{
\code{\link{ROC}}, \code{\link{Concordance}}
}
