% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Iterations.R
\name{.get_iteration_data}
\alias{.get_iteration_data}
\title{Internal function for creating or retrieving iteration data}
\usage{
.get_iteration_data(
  file_paths,
  data,
  experiment_setup,
  settings,
  message_indent = 0L,
  verbose = TRUE
)
}
\arguments{
\item{file_paths}{Set of paths to relevant files and directories.}

\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{experiment_setup}{data.table with subsampler information at different
levels of the experimental design.}

\item{settings}{List of parameter settings. Some of these parameters are
relevant to creating iterations.}

\item{message_indent}{Indenting of messages.}

\item{verbose}{Sets verbosity.}
}
\value{
A list with the following elements:
\itemize{
\item \code{iter_list}: A list containing iteration data at the different levels of
the experiment.
\item \code{project_id}: The unique project identifier.
\item \code{experiment_setup}: data.table with subsampler information at different
levels of the experimental design.
}
}
\description{
Internal function for creating or retrieving iteration data
}
\keyword{internal}
