/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.HashSet;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.BadModelException;
import jfm.model.ELSOption;
import jfm.model.ELSOptionComponent;
import jfm.model.Types;

public class FieldMarginsComponent
extends ELSOptionComponent {
    public static Set<Types.ELSCode> elscodes = new HashSet<Types.ELSCode>();

    public FieldMarginsComponent(double perhaEstablishmentCost, double perhaMaintenanceCost, double discountRate) {
        super(ModelComponent.MCType.FIELDMARGINS);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        double perAreaCost = perhaEstablishmentCost * discountRate + perhaMaintenanceCost;
        this.options.put(Types.ELSCode.EE3, new ELSOption(Types.ELSCode.EE3, perAreaCost, Types.ELSCode.EE3.defaultPoints));
        this.options.put(Types.ELSCode.EE2, new ELSOption(Types.ELSCode.EE2, perAreaCost, Types.ELSCode.EE2.defaultPoints));
        this.options.put(Types.ELSCode.EF1, new ELSOption(Types.ELSCode.EF1, perAreaCost, Types.ELSCode.EF1.defaultPoints));
    }

    public ModelComponent copy() {
        return null;
    }

    protected void initializeStructure() throws BadModelException {
        for (Types.ELSCode ecode : elscodes) {
            MatrixVariable newVariable = new MatrixVariable(-((ELSOption)this.options.get((Object)((Object)ecode))).costPerUnit, 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
            newVariable.setTag(ecode.toString());
            this.matrix.addVariable(newVariable);
            ((ELSOption)this.options.get((Object)ecode)).registerVariable(newVariable, 0);
            ((ELSOption)this.options.get((Object)ecode)).registerParent(this);
        }
    }

    protected String name() {
        return null;
    }

    public void setFormulaVariables() {
    }

    protected void updateStructure() {
        for (ELSOption op : this.options.values()) {
            op.updateStructure(this);
        }
        this.structureUpdateDone();
    }

    static {
        elscodes.add(Types.ELSCode.EE3);
        elscodes.add(Types.ELSCode.EE2);
        elscodes.add(Types.ELSCode.EF1);
    }

    public final class FieldMarginsMaxAreaConstraint
    extends ConstraintBuilder {
        public FieldMarginsMaxAreaConstraint() {
            super(ConstraintBuilder.CBType.FIELDMARGINSMAXAREA, ModelComponent.MCType.FIELDMARGINS);
        }

        protected void build() {
        }
    }
}

