/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.ArrayList;
import jfm.lp.LPX;
import jfm.model.Limit;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.TextParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

final class LimitParser
extends JFMObjectParser {
    Types.LimitType id;

    public LimitParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("id", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("min", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("max", JFMObjectParser.mandatoryAttribute);
        this.registerAttribute("type", JFMObjectParser.mandatoryAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        ArrayList<Object> subjects;
        LPX type;
        double max;
        double min;
        block6: {
            min = 0.0;
            max = 0.0;
            type = LPX.LPX_LO;
            subjects = new ArrayList<Object>();
            try {
                this.id = Types.xmlToLimitType(this.getNamedAttribute("id"));
                min = Double.parseDouble(this.getNamedAttribute("min"));
                max = Double.parseDouble(this.getNamedAttribute("max"));
                type = LPX.xmlToGLPKType(this.getNamedAttribute("type"));
                if (this.parserListExists("csv")) {
                    for (int i = 0; i < this.getParserList("csv").size(); ++i) {
                        TextParser csvp = (TextParser)this.getParserList("csv").get(i);
                        if (csvp.dataType != Types.TextDataType.CROPTYPE) continue;
                        String[] xmlcptypes = csvp.getCSV();
                        for (int j = 0; j < xmlcptypes.length; ++j) {
                            subjects.add((Object)Types.xmlToCropType(xmlcptypes[j]));
                        }
                    }
                    break block6;
                }
                throw new XMLSyntaxException("Subjects must be defined for limits");
            }
            catch (XMLSyntaxException ex) {
                throw new XMLSyntaxException(ex.getMessage());
            }
            catch (NumberFormatException ex) {
                throw new XMLSyntaxException(ex.getMessage());
            }
        }
        this.obj = new Limit(subjects, this.id, type, min, max);
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        return "LimitParser";
    }

    public String parsesNode() {
        return "limit";
    }

    public String toString() {
        return null;
    }
}

