% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_results.R
\name{write_results}
\alias{write_results}
\title{Write a data frame as a .xlsx, .xls, or .csv file}
\usage{
write_results(data, file_name, digits)
}
\arguments{
\item{data}{Data frame to be written to a directory.}

\item{file_name}{Character string naming the output file. Required.}

\item{digits}{Integer indicating the number of decimal places or significant digits used to round flow values. Use follows 
that of base::round() digits argument.}
}
\description{
Write a data frame to a directory with all numbers rounded to specified digits. Can write as .xls, .xlsx, or .csv 
   file types. Writing as .xlsx or .xls uses the 'writexl' package.
}
\examples{
\dontrun{

# Working examples:

# Example data to write
data_results <- calc_longterm_daily_stats(station_number = c("08HA002", "08HA011"),
                                          start_year = 1971, end_year = 2000)

# Write the data and round numbers to 1 decimal place
write_results(data = data_results, 
              file_name = "Cowichan River Long-term Flows (1971-2000).xlsx", 
              digits = 1)
              
}
}
