% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_monthly_stats2.R
\name{plot_monthly_stats2}
\alias{plot_monthly_stats2}
\title{Plot monthly summary statistics (as ribbons)}
\usage{
plot_monthly_stats2(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  roll_days = 1,
  roll_align = "right",
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  complete_years = FALSE,
  ignore_missing = FALSE,
  allowed_missing = ifelse(ignore_missing, 100, 0),
  plot_extremes = TRUE,
  plot_inner_percentiles = TRUE,
  plot_outer_percentiles = TRUE,
  inner_percentiles = c(25, 75),
  outer_percentiles = c(5, 95),
  log_discharge = TRUE,
  log_ticks = ifelse(log_discharge, TRUE, FALSE),
  scales_discharge = "fixed",
  include_title = FALSE
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank or set to \code{NULL} to include all years.}

\item{months}{Numeric vector of months to include in analysis. For example, \code{3} for March, \code{6:8} for Jun-Aug or 
\code{c(10:12,1)} for first four months (Oct-Jan) when \code{water_year_start = 10} (Oct). Default summarizes all 
months (\code{1:12}).}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}

\item{allowed_missing}{Numeric value between 0 and 100 indicating the \strong{percentage} of missing dates allowed to be
included to calculate a statistic (0 to 100 percent). If \code{'ignore_missing = FALSE'} then it defaults to \code{0} (zero missing dates allowed),
if \code{'ignore_missing = TRUE'} then it defaults to \code{100} (any missing dates allowed); consistent with 
\code{ignore_missing} usage. Supersedes \code{ignore_missing} when used.}

\item{plot_extremes}{Logical value to indicate plotting a ribbon with the range of daily minimum and maximum flows. 
Default \code{TRUE}.}

\item{plot_inner_percentiles}{Logical value indicating whether to plot the inner percentiles ribbon. Default \code{TRUE}.}

\item{plot_outer_percentiles}{Logical value indicating whether to plot the outer percentiles ribbon. Default \code{TRUE}.}

\item{inner_percentiles}{Numeric vector of two percentile values indicating the lower and upper limits of the 
inner percentiles ribbon for plotting. Default \code{c(25,75)}, set to \code{NULL} for no inner ribbon.}

\item{outer_percentiles}{Numeric vector of two percentile values indicating the lower and upper limits of the 
outer percentiles ribbon for plotting. Default \code{c(5,95)}, set to \code{NULL} for no outer ribbon.}

\item{log_discharge}{Logical value to indicate plotting the discharge axis (Y-axis) on a logarithmic scale. Default \code{FALSE}.}

\item{log_ticks}{Logical value to indicate plotting logarithmic scale ticks when \code{log_discharge = TRUE}. Ticks will not
appear when \code{log_discharge = FALSE}. Default to \code{TRUE} when \code{log_discharge = TRUE}.}

\item{scales_discharge}{String, either 'fixed' (all y-axis scales the same) or 'free' (each plot has their own scale). 
Default \code{'fixed'}.}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}
}
\value{
A list of ggplot2 objects for each monthly statistic for each station provided that contain:
  \item{Monthly Mean Flows}{mean of all daily flows for a given month and year}
  \item{Monthly Median Flows}{median of all daily flows for a given month and year}
  \item{Monthly Maximum Flows}{maximum of all daily flows for a given month and year}
  \item{Monthly Minimum Flows}{minimum of all daily flows for a given month and year}
  \item{Monthly P'n' Flows}{(optional) each n-th percentile selected for a given month and year}
}
\description{
Plots means, medians, maximums, minimums, and percentiles as ribbons for each month of all years of flow values 
   from a daily streamflow data set. Calculates statistics from all values, unless specified. Data calculated using the 
   \code{calc_monthly_stats()} function. Produces a list containing a plot for each statistic. Returns a list of plots.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot monthly statistics using a data frame and data argument with defaults
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
results <- plot_monthly_stats2(data = flow_data,
                               start_year = 1980)

# Plot monthly statistics for water years starting in October
results <- plot_monthly_stats2(station_number = "08NM116",
                              start_year = 1980,
                              end_year = 2010,
                              water_year_start = 10)
                   
}
}
\seealso{
\code{\link{calc_monthly_stats}}
}
