# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

fastHorseshoe <- function(Y, X, beta_hat = NULL, penalize = NULL, prior = "horseshoe", user_prior_function = NULL, sigma = NULL, s2 = 1, kap2 = 1, N = 20000L, burnin = 0L, thinning = 1L, vglobal = 100, verb = FALSE) {

     Y = as.matrix(Y)

     X = as.matrix(X)

     try(if(dim(Y)[1] != dim(X)[1]) stop("Length of X and Y don't agree."))
        
     if(is.null(beta_hat)){
         beta_hat = stats::lm(scale(Y) ~ scale(X) - 1)$coef
     }
     
     beta = beta_hat * 0.1

     # scale the initial value
     if(is.null(sigma)){
         sigma = 0.5 * stats::sd(Y)
     }

     if(is.null(penalize)){
         penalize = rep(1, dim(X)[2])
     }

     prior_type = switch(
                prior,
                horseshoe = 1L,
                doubleexp = 2L,
                normal = 3L,
                cauchy = 4L,
                5L
            )

    .Call('fastHorseshoe_fastHorseshoe', PACKAGE = 'fastHorseshoe', Y, X, beta_hat, beta, penalize, prior_type, user_prior_function, sigma, s2, kap2, N, burnin, thinning, vglobal, verb)
}

