% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastLSU.R
\name{fastLSU}
\alias{fastLSU}
\title{Fast Linear Step Up Procedure}
\usage{
fastLSU(pvalues, alpha = 0.05, algorithm = 1, mtg = NA, mtc = NA)
}
\arguments{
\item{pvalues}{A vector of p values.}

\item{alpha}{The desired significance level, the default is 0.05.}

\item{algorithm}{Value of 1 or 2, 1 indicating algorithm 1 in the reference paper for a single chunk without sorting the p values; 2 indicating algorithm 2  in the reference paper for two or more chunks of p values.}

\item{mtg}{Global number of p values in the problem (the sum of all p values in all chunks), should be NA if algorithm is 1.}

\item{mtc}{Number of p values in current chunk (should be less than mtg), should be NA if algorithm is 1.}
}
\value{
The result is a vector of significnat p values at the significance level of alpha.
}
\description{
Fast Linear Step Up procedure of Benjamini–Hochberg FDR method
}
\examples{
set.seed(111)
#simulate p-values for example;
pvals.sim = runif(30000)
Bsig = 1-rbinom(30000,1, .02)
Bsig[Bsig==0] = .0001
pvals.sim = pvals.sim*Bsig

# Example of a single chunk
results.allchunks = fastLSU(pvalues=pvals.sim,alpha=0.1, algorithm = 1)

# Example of 2 chunks of p-values (1st of 10,000, 2nd of 20,000)
pv.chunk1 = pvals.sim[1:10000]
pv.chunk2 = pvals.sim[10001:30000]
# Step 1:
results.chunk1 = fastLSU(pvalues=pv.chunk1,alpha=0.1, algorithm = 2,
 mtc=length(pv.chunk1),mtg=length(pvals.sim))

# Step 2:
results.chunk2 = fastLSU(pvalues=pv.chunk2,alpha=0.1, algorithm = 2,
mtc=length(pv.chunk2),mtg=length(pvals.sim))

# Step 3: # get final candidancy
cand.pvals = c(results.chunk1,results.chunk2)
# keep mtc equal to mtg, the fastLSU function already considers length(cand.pvals)
results.final = fastLSU(pvalues=cand.pvals,alpha=0.1, algorithm = 2,
 mtc=length(pvals.sim),mtg=length(pvals.sim))
}
\references{
The "fastLSU" package is created based on Vered Madar and Sandra Batista’s work.  For more details:

Madar V, Batista S. FastLSU: a more practical approach for the Benjamini-Hochberg FDR controlling procedure for huge-scale testing problems. Bioinformatics 2016; 32:1716-23.
}
\seealso{
\code{\link[stats]{p.adjust}}.
}

