% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fll_contin.R
\name{fsglmm}
\alias{fsglmm}
\title{Fitting Projection Based Laplace Approximation for Spatial Generalized Linear Mixed Model}
\usage{
fsglmm(
  formula,
  kappa,
  inits,
  data,
  coords,
  family,
  ntrial = 1,
  offset = NA,
  method.optim,
  method.integrate,
  rank = NULL,
  control = list()
)
}
\arguments{
\item{formula}{an object of class "formula."}

\item{kappa}{the smoothness parameter for the matern process (either 0.5, 1.5, 2.5 or 10).}

\item{inits}{starting values for the parameters.}

\item{data}{a data frame containing variables in the model.}

\item{coords}{a matrix of dimension \eqn{N} x 2 representing the longitude and latitude of each observation.}

\item{family}{a character string of the error distribution and link function to be used in the model.}

\item{ntrial}{a numeric vector for a binomial model.}

\item{offset}{this is used to specify an a priori a known component to be included in the linear predictor during fitting.}

\item{method.optim}{the method to be used for outer optimization. "CG" for Conjugate Gradient Method.}

\item{method.integrate}{the method to be used for inner optimization. "NR" for Newton Raphson Method.}

\item{rank}{an integer of 'rank' to be used for projections. Default is 5 percent of observations.}

\item{control}{a list of control parameters.}
}
\value{
a list containing the following components:

\code{summary} a summary of the fitted model

\code{vcov} a symmetric matrix giving an estimate of the Hessian at the solution found.

\code{mle2} an object of class "mle2"

\code{family} the family used.

\code{kappa} the matern smoothness parameter used.

\code{Delta} a matrix containing the estimated random effects of the reduced dimensional model.

\code{U} a matrix whose columns contain the estimated eigenvectors of the reduced dimensional model.

\code{D} a matrix whose diagonal components contain the estimated eigenvalues of the reduced dimensional model.

\code{coords} the matrix of coordinates used.
}
\description{
\code{fsglmm} is used to fit reduced-dimensional spatial generalized linear mixed models for continuous spatial domain.
}
\examples{
\donttest{
if(requireNamespace("mgcv")){
sigma2 = 1
phi = 0.2
beta.true = c(1,1)
n = 400
n.pred = 100
coords.all <- matrix(runif((n+n.pred)*2),ncol=2,nrow=n+n.pred)
X.all <- matrix(runif((n+n.pred)*2),ncol=2,nrow=(n+n.pred))
dist.all <- fields::rdist(coords.all,coords.all)
V.all <- sigma2*(1+sqrt(5)/phi*dist.all+5/(3*phi^2)*dist.all^2)*exp(-sqrt(5)/phi*dist.all)
set.seed(1)
r.e.all <- mgcv::rmvn(1,rep(0,nrow(coords.all)),V.all)
pi.all <- X.all\%*\%beta.true + r.e.all
p.all <- exp(pi.all)/(1+exp(pi.all))
Y.all <- sapply(p.all, function(x) sample(0:1, 1, prob = c(1-x, x)))
Y <- as.matrix(Y.all[1:n],nrow = n)
X <- X.all[1:n,]
coords <- coords.all[1:n,]
data <- data.frame(cbind(Y,X))
colnames(data) = c("Y","X1","X2")
mod.glm <- glm(Y~-1+X1+X2,family="binomial",data=data)
mod.glm.esp <- predict(mod.glm,data, type="response")
mod.glm.s2 <- var(Y - mod.glm.esp)
mod.glm.phi <- 0.1*max(dist(coords))
startinit <- c(mod.glm$coef,log(mod.glm.s2),log(mod.glm.phi))
names(startinit) <- c("X1","X2","logsigma2","logphi")
result.bin <- fsglmm(Y~-1+X1+X2, kappa=2.5, inits = startinit,
 data = data,coords = coords, family = "binomial", ntrial = 1,
 offset = NA,method.optim = "CG", method.integrate = "NR",rank = 50)
}
}
}
\references{
Jaewoo Park and Sangwan Lee - "A Projection-based Laplace Approximation for Spatial Latent Variable Models"
}
