% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastNaiveBayes.gaussian.R,
%   R/fastNaiveBayes.gaussian.default.R
\name{fastNaiveBayes.gaussian}
\alias{fastNaiveBayes.gaussian}
\alias{fastNaiveBayes.gaussian.default}
\title{Fast Naive Bayes Classifier with a Gaussian event model}
\usage{
fastNaiveBayes.gaussian(x, y, std_threshold = 0.01, sparse = FALSE,
  ...)

\method{fastNaiveBayes.gaussian}{default}(x, y, std_threshold = 0.01,
  sparse = FALSE, ...)
}
\arguments{
\item{x}{a numeric matrix. A sparse dgcMatrix is also accepted}

\item{y}{a factor of classes}

\item{std_threshold}{Default is 0.01. This sets a threshold for the standard deviation.
Now any features with 0 standard deviation are primed to have
std_threshold standard deviation instead to ensure proper probabilities.}

\item{sparse}{Use a sparse matrix? If true a sparse matrix will be constructed from x, which can give up to a 40% speed up.
It's possible to directly feed a sparse dgcMatrix as x, which will set this parameter to TRUE}

\item{...}{Not used.}
}
\value{
A fitted object of class "fastNaiveBayes.bernoulli". It has four components:

    \describe{
        \item{probability_table}{Posterior probabilities}
        \item{priors}{calculated prior probabilities for each class}
        \item{names}{names of features used to train this fastNaiveBayes}
    }
}
\description{
Extremely fast implementation of a Naive Bayes Classifier. This instance only uses the
Gaussian event model for all columns.
}
\details{
A Naive Bayes classifier that assumes independence between the feature variables. The Gaussian distribution
    should be used with numerical variables.

    By setting sparse = TRUE the numeric matrix x will be converted to a sparse dgcMatrix. This can be considerably faster
    in case few observations have a value different than 0.

    It's also possible to directly supply a sparse dgcMatrix, which can be a lot faster in case a fastNaiveBayes model
    is trained multiple times on the same matrix or a subset of this. See examples for more details. Bear in mind that
    converting to a sparse matrix can actually be slower depending on the data.
}
\examples{
rm(list = ls())
require(mlbench)
require(Matrix)

# Load BreastCancer data
data(BreastCancer)
dim(BreastCancer)
levels(BreastCancer$Class)
head(BreastCancer)

# Gaussian distribution example
data_mat <- BreastCancer[, c("Class", "Cl.thickness", "Cell.size", "Cell.shape", "Marg.adhesion")]

y <- data_mat[, "Class"]
data_mat <- data_mat[, setdiff(colnames(data_mat), c("Class"))]
for (i in 1:ncol(data_mat)) {
  data_mat[[i]] <- as.numeric(data_mat[[i]])
}

model <- fastNaiveBayes.gaussian(data_mat[1:400, ], y[1:400], laplace = 1, sparse = FALSE)
preds <- predict(model, newdata = data_mat[401:nrow(data_mat), ], type = "class")

mean(preds != y[401:length(y)])
}
\seealso{
\code{\link{predict.fastNaiveBayes.gaussian}} for the predict function for the fastNaiveBayes.gaussian class,
\code{\link{fastNaiveBayes.mixed}} for the general fastNaiveBayes model, \code{\link{fastNaiveBayes.bernoulli}} for a Bernoulli
distribution only model, and finally, \code{\link{fastNaiveBayes.multinomial}} for a multinomial only distribution model.
}
