% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{airlineArrival}
\alias{airlineArrival}
\title{Airline On-Time Arrival Data}
\format{A data frame with 11000 observations on the following 3 variables.
\itemize{ \item{Airport}{ a factor with levels \code{LosAngeles}
\code{Phoenix} \code{SanDiego} \code{SanFrancisco} \code{Seattle}}
\item{Result}{ a factor with levels \code{Delayed} \code{OnTime}}
\item{Airline}{ a factor with levels \code{Alaska}
\code{AmericaWest}} }}
\source{
Barnett, Arnold. 1994. ``How numbers can trick you.''
\emph{Technology Review}, vol. 97, no. 7, pp. 38--45.
}
\description{
Flights categorized by destination city, airline, and whether or not the
flight was on time.
}
\examples{
row.perc(xtabs(~Airline+Result, data=airlineArrival))
for (city in levels(airlineArrival$Airport)) {
	cat(paste('\\nArriving in ', city,':\\n',sep=''))
	print(row.perc(xtabs(~Airline+Result, airlineArrival,
		subset=Airport==city)))
}
}
\references{
These and similar data appear in many text books under the topic
of Simpson's paradox.
}
\keyword{datasets}

