% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{familySmoking}
\alias{familySmoking}
\title{Family smoking}
\format{A data frame with 5375 observations on the following 2 variables.
\itemize{ \item{Student}{ a factor with levels \code{DoesNotSmoke}
\code{Smokes}} \item{Parents}{ a factor with levels
\code{NeitherSmokes} \code{OneSmokes}} \code{BothSmoke} }}
\source{
S. V. Zagona (ed.), \emph{Studies and issues in smoking behavior},
University of Arizona Press, 1967.
}
\description{
A cross-tabulation of whether a student smokes and how many of his or her
parents smoke from a study conducted in the 1960's.
}
\examples{
data(familySmoking)
xchisq.test( xtabs(~Parents + Student, familySmoking) )
}
\references{
The data also appear in

Brigitte Baldi and David S. Moore, \emph{The Practice of Statistics in the
Life Sciences}, Freeman, 2009.
}
\keyword{datasets}

