% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnn_learner.R
\name{cnn_learner}
\alias{cnn_learner}
\title{Cnn_learner}
\usage{
cnn_learner(
  dls,
  arch,
  loss_func = NULL,
  pretrained = TRUE,
  cut = NULL,
  splitter = NULL,
  y_range = NULL,
  config = NULL,
  n_out = NULL,
  normalize = TRUE,
  opt_func = Adam(),
  lr = 0.001,
  cbs = NULL,
  metrics = NULL,
  path = NULL,
  model_dir = "models",
  wd = NULL,
  wd_bn_bias = FALSE,
  train_bn = TRUE,
  moms = list(0.95, 0.85, 0.95)
)
}
\arguments{
\item{dls}{data loader object}

\item{arch}{a model architecture}

\item{loss_func}{loss function}

\item{pretrained}{pre-trained or not}

\item{cut}{cut}

\item{splitter}{It is a function that takes self.model and returns a list of parameter groups (or just one parameter group if there are no different parameter groups).}

\item{y_range}{y_range}

\item{config}{configuration}

\item{n_out}{the number of out}

\item{normalize}{normalize}

\item{opt_func}{The function used to create the optimizer}

\item{lr}{learning rate}

\item{cbs}{Cbs is one or a list of Callbacks to pass to the Learner.}

\item{metrics}{It is an optional list of metrics, that can be either functions or Metrics.}

\item{path}{The folder where to work}

\item{model_dir}{Path and model_dir are used to save and/or load models.}

\item{wd}{It is the default weight decay used when training the model.}

\item{wd_bn_bias}{It controls if weight decay is applied to BatchNorm layers and bias.}

\item{train_bn}{It controls if BatchNorm layers are trained even when they are supposed to be frozen according to the splitter.}

\item{moms}{The default momentums used in Learner.fit_one_cycle.}
}
\value{
learner object
}
\description{
Build a convnet style learner from `dls` and `arch`
}
\examples{

\dontrun{

URLs_MNIST_SAMPLE()
# transformations
tfms = aug_transforms(do_flip = FALSE)
path = 'mnist_sample'
bs = 20

#load into memory
data = ImageDataLoaders_from_folder(path, batch_tfms = tfms, size = 26, bs = bs)


learn = cnn_learner(data, resnet18(), metrics = accuracy, path = getwd())

}

}
