% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_meanvariance}
\alias{fastcpd_meanvariance}
\alias{fastcpd.meanvariance}
\alias{fastcpd_mv}
\alias{fastcpd.mv}
\title{Find change points efficiently in mean variance change models}
\usage{
fastcpd_meanvariance(data, ...)

fastcpd.meanvariance(data, ...)

fastcpd_mv(data, ...)

fastcpd.mv(data, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a vector.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_meanvariance]{fastcpd_meanvariance()}}, \code{\link[=fastcpd.meanvariance]{fastcpd.meanvariance()}},
\code{\link[=fastcpd_mv]{fastcpd_mv()}}, \code{\link[=fastcpd.mv]{fastcpd.mv()}} are wrapper
functions of \code{\link[=fastcpd]{fastcpd()}} to find the meanvariance change. The
function is similar to \code{\link[=fastcpd]{fastcpd()}} except that the data is by
default a matrix or data frame or a vector with each row / element as an
observation and thus a formula is not required here.
}
\examples{
if (!requireNamespace("mvtnorm", quietly = TRUE)) utils::install.packages(
  "mvtnorm", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
p <- 3
result <- fastcpd.mv(
  rbind(
    mvtnorm::rmvnorm(300, mean = rep(0, p), sigma = diag(1, p)),
    mvtnorm::rmvnorm(400, mean = rep(10, p), sigma = diag(1, p)),
    mvtnorm::rmvnorm(300, mean = rep(0, p), sigma = diag(50, p)),
    mvtnorm::rmvnorm(300, mean = rep(0, p), sigma = diag(1, p)),
    mvtnorm::rmvnorm(400, mean = rep(10, p), sigma = diag(1, p)),
    mvtnorm::rmvnorm(300, mean = rep(10, p), sigma = diag(50, p))
  )
)
summary(result)
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
