% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.r
\name{extend,GRaster,numeric-method}
\alias{extend,GRaster,numeric-method}
\alias{extend}
\alias{extend,GRaster,SpatRaster-method}
\alias{extend,GRaster,SpatVector-method}
\alias{extend,GRaster,SpatExtent-method}
\alias{extend,GRaster,sf-method}
\alias{extend,GRaster,GSpatial-method}
\title{Add rows and columns around a writeRaster}
\usage{
\S4method{extend}{GRaster,numeric}(x, y, fill = NA)

\S4method{extend}{GRaster,SpatRaster}(x, y, snap = "near", fill = NA)

\S4method{extend}{GRaster,SpatVector}(x, y, snap = "near", fill = NA)

\S4method{extend}{GRaster,SpatExtent}(x, y, snap = "near", fill = NA)

\S4method{extend}{GRaster,sf}(x, y, snap = "near", fill = NA)

\S4method{extend}{GRaster,GSpatial}(x, y, snap = "near", fill = NA)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{y}{Any of:
\itemize{
\item An object from which an extent can be obtained; i.e., a \code{SpatRaster}, \code{SpatVector}, \code{SpatExtent}, \code{sf} vector, or a \code{GSpatial} object (any of \code{GRaster}, \code{GVector}, or \code{GRegion}). If the extent of \code{x} is "outside" the extent of \code{y} on any side, the side(s) of \code{x} that are outside will be kept as-is (i.e., the extent of \code{x} will never be shrunk).
\item A single positive integer: Number of rows and columns to add to the top, bottom, and sides of the raster.
\item Two integers >= 0: Number of columns (1st value) to add to the sides, and number of rows (2nd value) to add to the top and bottom of the raster.
\item Four integers >= 0: Number of rows and columns to add (left column, right column, bottom row, top row).
}}

\item{fill}{Numeric: Value to place in the new cells. The default is \code{NA}.}

\item{snap}{Character: Method used to align \code{y} to \code{x}. Partial matching is used. This is only used if \code{y} is not a set of numbers.
\itemize{
\item \code{"near"} (default): Round to nearest row/column
\item \code{"in"}: Round "inward" toward the extent of \code{x} to nearest row/column
\item \code{"out"}: Round "outward" away from the extent of \code{x} to the nearest row/column.
}}
}
\value{
A \code{GRaster}.
}
\description{
\code{extend()} adds cells around a raster, making it larger.
}
\details{
Known issues: When \code{GRaster}s are saved to disk explicitly using \code{\link[=writeRaster]{writeRaster()}}, or implicitly using \code{\link[=rast]{rast()}} or \code{\link[=plot]{plot()}}, rows and columns that are entirely \code{NA} are dropped.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")
madRivers <- fastData("madRivers")

# Send spatial objects to GRASS:
elev <- fast(madElev)
rivers <- fast(madRivers)

# Extend raster by number of rows/columns:
extended1 <- extend(elev, 10, fill = 900)
extended2 <- extend(elev, c(10, 20), fill = 900)
extended3 <- extend(elev, c(10, 80, 0, 100), fill = 900)
dim(elev)
dim(extended1)
dim(extended2)
dim(extended3)

plot(extended3)

# When exporting a raster, NA rows and columns are removed.
extended4 <- extend(elev, 100, fill=1) # default fill is NA
extended4terra <- rast(extended4)

dim(extended4)
dim(extended4terra)

plot(extended4)

# Extend the raster by another object with a wider extent.

# For tis example, first crop the raster, then extend it.
elevCrop <- crop(elev, rivers)
uncrop <- extend(elevCrop, elev, fill = 900)
plot(uncrop)

}
}
\seealso{
\code{\link[terra:extend]{terra::extend()}}
}
