% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareGeom.r
\name{compareGeom,GRaster,GRaster-method}
\alias{compareGeom,GRaster,GRaster-method}
\alias{compareGeom}
\alias{compareGeom,GVector,GVector-method}
\alias{compareGeom,GRaster,GVector-method}
\alias{compareGeom,GVector,GRaster-method}
\title{Determine if GRasters and/or GVectors are geographically comparable}
\usage{
\S4method{compareGeom}{GRaster,GRaster}(
  x,
  y,
  ...,
  location = TRUE,
  mapset = TRUE,
  topo = TRUE,
  lyrs = FALSE,
  crs = TRUE,
  ext = TRUE,
  zext = TRUE,
  rowcol = TRUE,
  depths = TRUE,
  res = TRUE,
  zres = TRUE,
  stopOnError = TRUE,
  messages = TRUE
)

\S4method{compareGeom}{GVector,GVector}(
  x,
  y,
  ...,
  location = TRUE,
  mapset = TRUE,
  topo = FALSE,
  crs = TRUE,
  ext = FALSE,
  zext = FALSE,
  geometry = FALSE,
  stopOnError = TRUE,
  messages = TRUE
)

\S4method{compareGeom}{GRaster,GVector}(
  x,
  y,
  ...,
  location = TRUE,
  mapset = TRUE,
  topo = FALSE,
  crs = TRUE,
  ext = FALSE,
  zext = FALSE,
  stopOnError = TRUE,
  messages = TRUE
)

\S4method{compareGeom}{GVector,GRaster}(
  x,
  y,
  ...,
  location = TRUE,
  mapset = TRUE,
  topo = FALSE,
  crs = TRUE,
  ext = FALSE,
  zext = FALSE,
  stopOnError = TRUE,
  messages = TRUE
)
}
\arguments{
\item{x, y, ...}{\code{GRaster}s or \code{GVector}s. If \code{y} is \code{GRaster}, then the \code{...} must also be \code{GRaster}s (or missing). If \code{y} is \code{GVector}, then the \code{...} must also be \code{GVector}s (or missing).}

\item{location, mapset}{Logical: Compare \strong{GRASS} "project/location" and "mapsets" (see \code{vignette("projects_mapsets", package = "fasterRaster")}). Default is \code{TRUE}.}

\item{topo}{Logical: Test for same topology (2D or 3D). By default, this is \code{TRUE} for raster-raster comparisons, and \code{FALSE} for all others.}

\item{lyrs}{Logical (rasters only): Compare number of layers of "stacked" rasters. Note this is different from number of vertical "depths" of a raster. Default is \code{FALSE}.}

\item{crs}{Logical: Compare coordinate reference systems. Default is \code{TRUE}.}

\item{ext}{Logical: If \code{TRUE}, test for same extent. By default, is \code{TRUE} for raster-raster comparison and \code{FALSE} for all others.}

\item{zext}{Logical: Test for same vertical extents (3D only). By default, this is \code{TRUE} for raster-raster comparisons, and \code{FALSE} for all others.}

\item{rowcol}{Logical (rasters only): Test for same number of rows and columns. Default is \code{TRUE}.}

\item{depths}{Logical (rasters only): Test for same number of depths. Default is \code{TRUE}.}

\item{res}{Logical (rasters only): Test for same resolution in x- and y-dimensions. Default is \code{TRUE}.}

\item{zres}{Logical (rasters only): Test for same resolution in z dimension. Default is \code{TRUE}.}

\item{stopOnError}{Logical: If \code{TRUE} (default), throw an error with an explanation if the objects are not comparable. If \code{FALSE} (default), return \code{TRUE} or \code{FALSE}.}

\item{messages}{Logical: If \verb{TRUE (default), display a warning if a condition is not met. This only comes into effect if }stopOnError\code{is}FALSE`.}

\item{geometry}{Logical (vector-vector comparison only): Compare geometry. Default is \code{FALSE}.}
}
\value{
Logical (invisibly): \code{TRUE} for no mismatches detected, \code{FALSE} for incompatibility), or side effect of throwing an error.
}
\description{
\code{compareGeom()} compares geographic metadata between two or more \code{GRaster}s and/or \code{GVector}s. In many cases, spatial objects must be comparable for them to "interact" (e.g., conducting arithmetic operations, masking, etc.).
}
