% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_id.R
\name{group_id}
\alias{group_id}
\alias{row_id}
\alias{f_consecutive_id}
\title{Fast group and row IDs}
\usage{
group_id(x, order = TRUE, ascending = TRUE, as_qg = FALSE)

row_id(x, ascending = TRUE)

f_consecutive_id(x)
}
\arguments{
\item{x}{A vector or data frame.}

\item{order}{Should the groups be ordered?
When order is \code{TRUE} (the default) the group IDs will be
ordered but not sorted. \cr
If \code{FALSE} the order of the group IDs will be based on first appearance.}

\item{ascending}{Should the order be ascending or descending?
The default is \code{TRUE}. \cr
For \code{row_id()} this determines if the row IDs are in
increasing or decreasing order. \cr}

\item{as_qg}{Should the group IDs be returned as a
collapse "qG" class? The default (\code{FALSE}) always returns
an integer vector.}
}
\value{
An integer vector.
}
\description{
These are tidy-based functions for calculating group IDs and row IDs. \cr
\itemize{
\item \code{group_id()} returns an integer vector of group IDs
the same size as the \code{x}.
\item \code{row_id()} returns an integer vector of row IDs.
\item \code{f_consecutive_id()} returns an integer vector of consecutive run IDs.
}

The \code{add_} variants add a column of group IDs/row IDs.
}
\details{
\bold{Note} - When working with data frames it is highly recommended
to use the \code{add_} variants of these functions. Not only are they more
intuitive to use, they also have optimisations for large numbers of groups.
\subsection{\code{group_id}}{

This assigns an integer value to unique elements of a vector or unique
rows of a data frame. It is an extremely useful function for analysis
as you can compress a lot of information into a single column, using that
for further operations.
}

\subsection{\code{row_id}}{

This assigns a row number to each group. To assign plain row numbers
to a data frame one can use \code{add_row_id()}.
This function can be used in rolling calculations, finding duplicates and
more.
}

\subsection{\code{consecutive_id}}{

An alternative to \code{dplyr::consecutive_id()}, \code{f_consecutive_id()} also
creates an integer vector with values in the range \verb{[1, n]} where
\code{n} is the length of the vector or number of rows of the data frame.
The ID increments every time \code{x[i] != x[i - 1]} thus giving information on
when there is a change in value.
\code{f_consecutive_id} has a very small overhead in terms
of calling the function, making it suitable for repeated calls.
}
}
\seealso{
\link{add_group_id} \link{add_row_id} \link{add_consecutive_id}
}
