% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastpos.R
\name{find_critical_pos}
\alias{find_critical_pos}
\title{Find the critical point of stability}
\usage{
find_critical_pos(
  rhos,
  precision = 0.1,
  precision_rel = FALSE,
  sample_size_min = 20,
  sample_size_max = 1000,
  n_studies = 10000,
  confidence_levels = c(0.8, 0.9, 0.95),
  pop_size = 1e+06
)
}
\arguments{
\item{rhos}{Vector of population correlations (can also be a single
correlation).}

\item{precision}{Precision around the correlation which is acceptable
(defaults to 0.1). The precision will determine the corridor of stability which is just rho+-precision.}

\item{precision_rel}{Whether the precision is absolute (rho+-precision or
relative rho+-rho*precision), boolean (defaults to FALSE).}

\item{sample_size_min}{Minimum sample size for each study (defaults to 20).}

\item{sample_size_max}{Maximum sample size for each study (defaults to 1e3).}

\item{n_studies}{Number of studies to run for each rho (defaults to 10e3).}

\item{confidence_levels}{Confidence levels for point of stability. This
corresponds to the quantile of the distribution of all found critical
sample sizes (defaults to c(.8, .9, .95)).}

\item{pop_size}{Population size (defaults to 1e6).}
}
\value{
A data frame containing all the above information, as well as the
  points of stability.
}
\description{
Run simulations for one or several population correlations and return the
critical points of stability (POS). The critical point of stability is the
sample size at which a certain percentage of studies will fall into an a
priori specified interval and stay in this interval if the sample size is
increased further.
}
\examples{
find_critical_pos(rho = 0.5)
find_critical_pos(rho = c(0.4, 0.5))
}
