% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_read_collection.R
\name{qc_read_collection}
\alias{qc_read_collection}
\title{Read a collection of FastQC data files}
\usage{
qc_read_collection(files, sample_names, modules = "all", verbose = TRUE)
}
\arguments{
\item{files}{A \code{character} vector of paths to the files to be imported.}

\item{sample_names}{A \code{character} vector of length equals that of the first argument \code{files}}

\item{modules}{Character vector containing the names of FastQC modules for
  which you want to import/inspect the data. Default is all. Allowed values include
  one or the combination of:
  \itemize{
   \item "Summary",
   \item "Basic Statistics",
   \item "Per base sequence quality",
   \item "Per tile sequence quality",
   \item "Per sequence quality scores",
   \item "Per base sequence content",
   \item "Per sequence GC content",
   \item "Per base N content",
   \item "Sequence Length Distribution",
   \item "Sequence Duplication Levels",
   \item "Overrepresented sequences",
   \item "Adapter Content",
   \item "Kmer Content"
  }
Partial match of module names allowed. For example,
you can use modules = "GC content", instead of the full names modules = "Per sequence GC content".}

\item{verbose}{logical value. If TRUE, print filename when reading.}
}
\value{
A \code{list} of \code{tibbles} containing the data of specified modules form each file.
}
\description{
A wrapper function around \link{qc_read} to read multiple FastQC data files at once.
}
\examples{
# extract paths to the demo files
qc.dir <- system.file("fastqc_results", package = "fastqcr")
qc.files <- list.files(qc.dir, full.names = TRUE)

# read all modules in all files
qc <- qc_read_collection(qc.files, sample_names = paste('S', 1:5, sep = ''))


# read a specified module in all files
qc <- qc_read_collection(qc.files, 
    sample_names = paste('S', 1:5, sep = ''),
    modules = "Per base sequence quality")

}
\author{
Mahmoud Ahmed, \email{mahmoud.s.fahmy@students.kasralainy.edu.eg}
}
