% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norta.R
\name{convert_r}
\alias{convert_r}
\title{Convert r for NORTA}
\usage{
convert_r(
  target_r = 0,
  dist1 = "norm",
  dist2 = "norm",
  params1 = list(),
  params2 = list(),
  tol = 0.01
)
}
\arguments{
\item{target_r}{The target correlation}

\item{dist1}{The target distribution function for variable 1 (e.g., norm, binom, gamma, truncnorm)}

\item{dist2}{The target distribution function for variable 2}

\item{params1}{Arguments to pass to the functions for distribution 1}

\item{params2}{Arguments to pass to the functions for distribution 2}

\item{tol}{Tolerance for optimise function}
}
\value{
r-value to induce in the bivariate normal variables
}
\description{
Given a target r-value, returns the correlation you need to induce in a bivariate normal distribution to have the target correlation after converting distributions.
}
\details{
See \link[stats:Distributions]{Distributions} for distributions and their various arguments to specify in params1 and params2.
}
\examples{
convert_r(target_r = 0.5, 
          dist1 = "norm", 
          dist2 = "binom", 
          params1 = list(mean = 100, sd = 10),
          params2 = list(size = 1, prob = 0.5))
          
convert_r(target_r = 0.5, 
          dist1 = "norm", 
          dist2 = "likert", 
          params1 = list(mean = 100, sd = 10),
          params2 = list(prob = c(5, 10, 20, 30, 20)))
}
