% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.paired.R
\name{boot.paired.roc}
\alias{boot.paired.roc}
\title{Bootstrap paired ROC curves}
\usage{
boot.paired.roc(pred1, pred2, true.class, stratify = TRUE, n.boot = 1000,
  use.cache = FALSE, tie.strategy = NULL)
}
\arguments{
\item{pred1}{Numerical predictions for the first classifier.}

\item{pred2}{Numerical predictions for the second classifier.}

\item{true.class}{A logical vector. TRUE indicates the sample belonging to the
positive class.}

\item{stratify}{Logical. Indicates whether we use stratified bootstrap.
Default to TRUE. Non-stratified bootstrap is not yet implemented.}

\item{n.boot}{A number that will be coerced to integer. Specified the
number of bootstrap replicates. Defaults to 1000.}

\item{use.cache}{If true the bootstrapping results for the
ROC curve will be pre-cached. This increases speed when the object is used often, but also
takes up more memory.}

\item{tie.strategy}{How to handle ties. See details below.}
}
\value{
A list of class \code{fbroc.paired.roc}, containing the elements:
\item{prediction1}{Input predictions for first model.}
\item{prediction2}{Input predictions for second model.}
\item{true.class}{Input classes.}
\item{n.thresholds1}{Number of thresholds of the first predictor.}
\item{n.thresholds2}{Number of thresholds of the second predictor.}
\item{n.boot}{Number of bootstrap replicates.}
\item{use.cache}{Indicates if cache is used for this ROC object.}
\item{tie.strategy}{Used setting how to handle ties in predictors.}
\item{n.pos}{Number of positive observations.}
\item{n.neg}{Number of negative observations.}
\item{roc1}{A data.frame containing the thresholds of the first ROC curve and the TPR and FPR at these
thresholds.}
\item{roc2}{A data.frame containing the thresholds of the second ROC curve and the TPR and FPR at these
thresholds.}
\item{auc1}{The AUC of the first ROC curve.}
\item{auc2}{The AUC of the second ROC curve.}
\item{boot.tpr1}{If the cache is enabled, a matrix containing the bootstrapped TPR at the thresholds
for the first predictor.}
\item{boot.fpr1}{If the cache is enabled, a matrix containing the bootstrapped FPR at the thresholds
for the first predictor.}
\item{boot.tpr2}{If the cache is enabled, a matrix containing the bootstrapped TPR at the thresholds
for the second predictor.}
\item{boot.fpr2}{If the cache is enabled, a matrix containing the bootstrapped FPR at the thresholds
for the second predictor.}
}
\description{
Given two numerical predictors for the same outcome on the same set of samples, this functions
enables the bootstrapping of the paired ROC curves of the two prediction models. While bootstrapping
the same set of samples are used for both curves in each iteration, preserving the correlation
between the two models.
}
\section{Caching}{

If you enable caching, \code{boot.roc} calculates the requested number of bootstrap samples and
saves the TPR and FPR values for each iteration. This can take up a sizable portion of memory,
but it speeds up subsequent operations. This can be useful if you plan to use the ROC curve
multiple \code{fbroc} functions.
}

\section{Ties}{

You can set this parameter to either 1 or 2. If your numerical predictor has no ties, both settings
will produce the same results.
If you set \code{tie.strategy} to 1 the ROC curve is built by connecting the TPR/FPR pairs for
neighboring thresholds. A tie.strategy of 2 indicates that the TPR calculated at a specific FPR
is the best TPR at a FPR smaller than or equal than the FPR specified. Defaults to 2.
}
\examples{
data(roc.examples)
# Do not use cache
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier,
                          roc.examples$True.Class, n.boot = 500)
perf(example, "auc") # estimate difference in auc
perf(example, "tpr", fpr = 0.5) # estimate difference in TPR at a FPR of 50\%
plot(example) # show plot
# Cached mode
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier,
                          roc.examples$True.Class, n.boot = 1000, use.cache = TRUE)
conf(example, conf.for = "tpr", steps = 10) # get confidence regions for TPR at FPR
conf(example, conf.for = "fpr", steps = 10) # get confidence regions for FPR at TPR
perf(example, "fpr", tpr = 0.9) # estimate difference in FPR at a TPR of 90\%
}
\seealso{
\code{\link{boot.roc}},
         \code{\link{plot.fbroc.paired.roc}},
         \code{\link{perf.fbroc.paired.roc}}
}

