#' Descriptions for data files
#'
#' @format ## `file_metadata`
#' A data frame with 36 rows and 2 columns:
#' \describe{
#'   \item{file_prefix}{Data file root name}
#'   \item{description}{Short description of data file}
#' }
#' @source Metadata files headers
"file_metadata"

#' Dictionary for INV_CODE variable of RCB file
#'
#' @format ## `RCB__INV_CODE`
#' A data frame with 35 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCB.TXT
"RCB__INV_CODE"

#' Dictionary for AssetCodeRCB2 variable of RCB2 file
#'
#' @format ## `RCB2__AssetCodeRCB2`
#' A data frame with 17 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCB2.TXT
"RCB2__AssetCodeRCB2"

#' Dictionary for DebtMaturityCode variable of RCB3 file
#'
#' @format ## `RCB3__DebtMaturityCode`
#' A data frame with 10 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCB3.TXT
"RCB3__DebtMaturityCode"

#' Dictionary for LOANSTATUS variable of RCF file
#'
#' @format ## `RCF__LOANSTATUS`
#' A data frame with 6 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCF.TXT
"RCF__LOANSTATUS"

#' Dictionary for LOANSTATUS variable of RCF1 file
#'
#' @format ## `RCF1__LOANSTATUS`
#' A data frame with 13 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCF1.TXT
"RCF1__LOANSTATUS"

#' Dictionary for DerivCode variable of RCI2B file
#'
#' @format ## `RCI2B__DerivCode`
#' A data frame with 23 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCI2B_2018.TXT
"RCI2B__DerivCode"

#' Dictionary for ExposureCode variable of RCI2C file
#'
#' @format ## `RCI2C__ExposureCode`
#' A data frame with 12 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCI2C_2018.TXT
"RCI2C__ExposureCode"

#' Dictionary for DerivRMCode variable of RCI2D file
#'
#' @format ## `RCI2D__DerivRMCode`
#' A data frame with 11 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCI2D_2018.TXT
"RCI2D__DerivRMCode"

#' Dictionary for ASSET_CODE variable of RCO file
#'
#' @format ## `RCO__ASSET_CODE`
#' A data frame with 12 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCO.TXT
"RCO__ASSET_CODE"

#' Dictionary for RegCapCode variable of RCR3 file
#'
#' @format ## `RCR3__RegCapCode`
#' A data frame with 15 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCR3.TXT
"RCR3__RegCapCode"

#' Dictionary for RegCapCode variable of RCR7 file
#'
#' @format ## `RCR7__RegCapCode`
#' A data frame with 29 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RCR7.TXT
"RCR7__RegCapCode"

#' Dictionary for RegCapCode variable of RID file
#'
#' @format ## `RID__CAP_CODE`
#' A data frame with 12 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RID.TXT
"RID__CAP_CODE"

#' Dictionary for ACLCode variable of RIE1 file
#'
#' @format ## `RIE1__ACLCode`
#' A data frame with 7 rows and 2 columns:
#' \describe{
#'   \item{code}{Integer code}
#'   \item{value}{Character description}
#' }
#' @source D_RIE1.TXT
"RIE1__ACLCode"
