% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.R
\name{confint_binom}
\alias{confint_binom}
\title{Binomial proportion confidence intervals}
\usage{
confint_binom(n, N, cl = 0.95, acc = 0.001)
}
\arguments{
\item{n}{number of successes. Numeric vector of length one.}

\item{N}{number of trials. Numeric vector of length one.}

\item{cl}{confidence level for the returned confidence interval.
A number between zero and one.}

\item{acc}{required accuracy in the confidence interval endpoints.
A positive number.}
}
\value{
a numeric vector of length two, containing the confidence interval
endpoints.
}
\description{
Build confidence intervals for binomial proportions using the Feldman-Cousins
construction (Feldman and Cousins, 1998).
}
\details{
More details on the Feldman-Cousins construction can be found in the
documentation page of \link[fcci]{confint_pois}.
}
\examples{
confint_binom(50, 100, cl = 0.95, acc = 1e-3)
}
\references{
Feldman, Gary J. and Cousins, Robert D.
"Unified approach to the classical statistical analysis of small signals"
\emph{Phys. Rev. D} \strong{57}, issue 7 (1998): 3873-3889.
}
\seealso{
\link[fcci]{confint_pois}
}
