% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_intersect}
\alias{fct_intersect}
\title{Get Intersection of Factor Levels from Multiple Vectors}
\usage{
fct_intersect(...)
}
\arguments{
\item{...}{Factor vectors to be intersected.}
}
\value{
A factor vector containing the intersection of levels from all provided factors.
}
\description{
Combines multiple factor vectors and returns a factor vector containing only the levels common to all.
}
\examples{
# Example factor vectors
factor_vec1 <- factor(c('apple', 'banana', 'cherry'))
factor_vec2 <- factor(c('banana', 'date', 'cherry'))
factor_vec3 <- factor(c('banana', 'cherry', 'fig'))

# Get intersection of levels
fct_intersect(factor_vec1, factor_vec2, factor_vec3)
}
\author{
Kai Guo
}
