% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_replace.R
\name{fct_replace}
\alias{fct_replace}
\title{Replace a Factor Level and Optionally Insert at Specified Position}
\usage{
fct_replace(factor_vec, old_level, new_level, position = NULL)
}
\arguments{
\item{factor_vec}{A factor vector in which a level will be replaced.}

\item{old_level}{A character string specifying the level to be replaced.}

\item{new_level}{A character string specifying the new level to replace the old level.}

\item{position}{Optional. A positive integer specifying the position to insert the new level in the levels vector. If \code{NULL}, the original level order is preserved. Default is \code{NULL}.}
}
\value{
A factor vector with the level replaced and the new level optionally inserted at the specified position.
}
\description{
Replaces a specified level in a factor vector with a new level. If a position is provided, the new level is inserted at the specified position among the levels; otherwise, the original level order is preserved.
}
\examples{
#
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date', 'fig', 'grape'))

# replace 'banana' as 'blueberry', and keep original order
fct_replace(factor_vec, old_level = 'banana', new_level = 'blueberry')

# replace 'banana' as 'blueberry'
fct_replace(factor_vec, old_level = 'banana', new_level = 'blueberry', position = 2)
}
\author{
Kai Guo
}
