% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S.np.R
\name{S.np}
\alias{S.np}
\alias{S.LLR}
\alias{S.KNN}
\alias{S.LPR}
\alias{S.LCR}
\alias{S.NW}
\title{Smoothing matrix by nonparametric methods}
\usage{
S.LLR(tt, h, Ker = Ker.norm, w = NULL, cv = FALSE)

S.LPR(tt, h, p = 1, Ker = Ker.norm, w = NULL, cv = FALSE)

S.LCR(tt, h, Ker = Ker.norm, w = NULL, cv = FALSE)

S.KNN(tt, h = NULL, Ker = Ker.unif, w = NULL, cv = FALSE)

S.NW(tt, h = NULL, Ker = Ker.norm, w = NULL, cv = FALSE)
}
\arguments{
\item{tt}{Vector of discretization points or distance matrix \code{mdist}}

\item{h}{Smoothing parameter or bandwidth. In S.KNN, number of k-nearest neighbors.}

\item{Ker}{Type of kernel used, by default normal kernel.}

\item{w}{Optional case weights.}

\item{cv}{If \code{TRUE}, cross-validation is done.}

\item{p}{Polynomial degree.
be passed by default to \link[fda]{create.basis}}
}
\value{
Return the smoothing matrix \code{S}.
\itemize{
 \item {\code{S.LLR}}{ return the smoothing matrix by  Local Linear Smoothing.}
 \item { \code{S.NW}}{ return the smoothing matrix by Nadaraya-Watson kernel estimator.}
 \item {\code{S.KNN}}{ return the smoothing matrix by k nearest neighbors estimator.}
 \item {\code{S.LPR}}{ return the smoothing matrix by Local Polynomial Regression Estimator.}
 \item {\code{S.LCR}}{ return the smoothing matrix by Cubic Polynomial Regression.}
 }
}
\description{
Provides the smoothing matrix \code{S} for the discretization points \code{tt}
}
\details{
Options: 
\itemize{
 \item Nadaraya-Watson kernel estimator (S.NW) with bandwidth parameter \code{h}. 
 \item Local Linear Smoothing (S.LLR) with bandwidth parameter \code{h}.
 \item K nearest neighbors estimator (S.KNN) with parameter \code{knn}.
 \item Polynomial Local Regression Estimator (S.LCR) with parameter of polynomial \code{p} and of kernel \code{Ker}.
 \item Local Cubic Regression Estimator (S.LPR) with kernel \code{Ker}.
 }
}
\examples{
\dontrun{
  tt=1:101
  S=S.LLR(tt,h=5)
  S2=S.LLR(tt,h=10,Ker=Ker.tri)
  S3=S.NW(tt,h=10,Ker=Ker.tri)
  S4=S.KNN(tt,h=5,Ker=Ker.tri)
  par(mfrow=c(2,3))
  image(S)
  image(S2)
  image(S3)
  image(S4)
  S5=S.LPR(tt,h=10,p=1, Ker=Ker.tri)
  S6=S.LCR(tt,h=10,Ker=Ker.tri)
  image(S5)
  image(S6)
}
}
\references{
Ferraty, F. and Vieu, P. (2006). \emph{Nonparametric functional data analysis.} Springer Series in Statistics, New York. 
  
Wasserman, L. \emph{All of Nonparametric Statistics}. Springer Texts in Statistics, 2006.
  
Opsomer, J. D., and Ruppert, D. (1997). Fitting a bivariate additive model by local polynomial regression. \emph{The Annals of Statistics}, 25(1), 186-211.
}
\seealso{
See Also as \code{\link{S.basis}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente \email{manuel.oviedo@udc.es}
}
\keyword{smooth}
