% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mat2fd}
\alias{mat2fd}
\title{Obtain a fd object from a matrix}
\usage{
mat2fd(mat_obj, range_val = c(0, 1), argvals = NULL)
}
\arguments{
\item{mat_obj}{A matrix that contains the
discretized functional observations.}

\item{range_val}{A numeric vector of length 2
that contains the range of the observed functional
data. By default \code{range_val = c(0,1)}.}

\item{argvals}{Optinal argument that contains
a strictly increasing vector
of argument values at which line segments join
to form a polygonal line. If \code{argvals = NULL},
it is assumed a equidistant discretization vector.
By default \code{argvals = NULL}.}
}
\value{
A fd object obtained from the functional
observations in \code{mat_obj}.
}
\description{
This function returns a \code{fd} object
obtained from the discretized functional observations
contained in \code{mat_obj}.

It is assumed that the functional observations
contained in \code{mat_obj} are real observations,
hence a poligonal base will be used to obtain
the functional object.
}
\examples{
# Example 1
N <- 100
dv <- 30
v <- seq(from = 0, to = 1, length.out = dv)
set.seed(150) # For replication
mat_func_obs <- matrix(rnorm(N*dv), 
                       nrow = N, 
                       ncol = dv)
fd_func_obs <- mat2fd(mat_obj = mat_func_obs,
                      range_val = range(v),
                      argvals = v)
plot(fd_func_obs)
}
