% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEMobjects.R
\name{create.FEM.basis}
\alias{create.FEM.basis}
\title{Create a FEM basis}
\usage{
create.FEM.basis(mesh)
}
\arguments{
\item{mesh}{A \code{mesh.2D} or \code{mesh.2.5D} object representing the domain triangulation. 
See \link{create.mesh.2D}, \link{create.mesh.2.5D}.}
}
\value{
A \code{FEMbasis} object. This contains the \code{mesh}, along with some additional quantities:
\itemize{
	\item{\code{order}}{Either "1" or "2". Order of the Finite Element basis.} 
	\item{\code{nbasis}}{Scalar. The number of basis.} 
	\item{\code{transf_coord}}{It takes value only in the 2D case. It is a list of 4 vectors: diff1x, diff1y, diff2x and diff2y.
	Each vector has length #triangles and encodes the information for the tranformation matrix that transforms the 
	nodes of the reference triangle to the nodes of the i-th triangle. 
	The tranformation matrix for the i-th triangle has the form [diff1x[i] diff2x[i]; diff1y[i] diff2y[i]].}
	\item{\code{detJ}}{It takes value only in the 2D case. A vector of length #triangles. The ith element contains 
	the determinant of the transformation from the reference triangle to the nodes of the i-th triangle. 
	Its value is also the double of the area of each triangle of the basis.}
}
}
\description{
Sets up a Finite Element basis. It requires a \code{mesh.2D} or \code{mesh.2.5D} object, 
as input. 
The basis' functions are globally continuos functions, that are polynomials once restricted to a triangle in the mesh. 
The current implementation includes linear finite elements (when \code{order = 1} in the input \code{mesh}) and 
quadratic finite elements (when \code{order = 2} in the input \code{mesh}).
}
\examples{
## Upload the quasicircle2D data
data(quasicircle2D)
boundary_nodes = quasicircle2D$boundary_nodes
boundary_segments = quasicircle2D$boundary_segments
locations = quasicircle2D$locations
data = quasicircle2D$data

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)
## Plot it
plot(mesh)                   
## Create the basis
FEMbasis = create.FEM.basis(mesh)
## Upload the hub2.5D data
data(hub2.5D)
hub2.5D.nodes = hub2.5D$hub2.5D.nodes
hub2.5D.triangles = hub2.5D$hub2.5D.triangles

## Create the 2.5D mesh
mesh = create.mesh.2.5D(nodes = hub2.5D.nodes, triangles = hub2.5D.triangles)
## Plot it
plot(mesh)                   
## Create the basis
FEMbasis = create.FEM.basis(mesh)
}
\seealso{
\code{\link{create.mesh.2D}}, \code{\link{create.mesh.2.5D}}
}
