% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceDataObject.R
\docType{class}
\name{inferenceDataObject-class}
\alias{inferenceDataObject-class}
\alias{inferenceDataObject}
\title{Class for inference data}
\description{
A class that contains all possible information for inference over linear parameters and/or nonparametric field in spatial regression with
differential regularization problem. This object can be used as parameter in smoothing function of the fdaPDE library \code{\link{smooth.FEM}}.
}
\details{
At least one between test and interval must be nonzero. \code{n_cov}, \code{coeff} and \code{beta0}, if provided, need to be coherent. 
\code{dim} and \code{locations}, if provided, need to be coherent.
The usage of \code{\link{inferenceDataObjectBuilder}} is recommended for the construction of an object of this class.
}
\section{Slots}{

\describe{
\item{\code{test}}{A vector of integers taking value 0, 1 or 2; if 0 no test is performed, if 1 one-at-the-time tests are performed, if 2 a simultaneous test is performed.}

\item{\code{interval}}{A vector of integers taking value 0, 1, 2 or 3; if 0 no confidence interval is computed, if 1 one-at-the-time confidence intervals are computed, 
if 2 simultaneous confidence intervals are computed, if 3 Bonferroni confidence intervals are computed.}

\item{\code{type}}{A vector of integers taking value 1, 2, 3, 4 or 5 corresponding to Wald, Speckman, Eigen-Sign-Flip, Enhanced-Eigen-Sign-Flip or Sign-Flip inferential approach.}

\item{\code{component}}{A vector of integers taking value 1, 2 or 3, indicating whether the inferential analysis should be carried out respectively for the parametric, nonparametric or both the components.}

\item{\code{exact}}{An integer taking value 1 or 2. If 1 an exact computation of the test statistics will be performed,
whereas if 2 an approximated computation will be carried out (not implemented in this version).}

\item{\code{dim}}{Dimension of the problem, it is equal to 2 in the 1.5D and 2D cases and equal to 3 in the 2.5D and 3D cases.}

\item{\code{n_cov}}{Number of covariates taken into account in the linear part of the regression problem.}

\item{\code{locations}}{A matrix of numeric coefficients with columns of dimension \code{dim}. When nonparametric inference is requested it represents the set of spatial locations for which the inferential analysis should be performed. 
The default values is a one-dimensional matrix of value 1 indicating that all the observed location points should be considered. 
In the sign-flip and eigen-sign-flip implementations only observed points are allowed.}

\item{\code{locations_indices}}{A vector of indices indicating which spatial points have to be considered among the observed ones for nonparametric inference. If a vector of location indices is provided
then the slot 'location' is discarded.}

\item{\code{locations_are_nodes}}{An integer taking value 1 or 2; in the first case it indicates that the selected locations to perform inference on f are all coinciding with the nodes; otherwise it takes value 2;}

\item{\code{coeff}}{A matrix of numeric coefficients with columns of dimension \code{n_cov} and each row represents a linear combination of the linear parameters to be tested and/or to be
estimated via confidence interval.}

\item{\code{beta0}}{Vector of null hypothesis values for the linear parameters of the model. Used only if \code{test} is not 0 and \code{component} is not 2.}

\item{\code{f0}}{Function representing the expression of the nonparametric component f under the null hypothesis. Used only if \code{component} is not 1.}

\item{\code{f0_eval}}{Vector of f0 evaluations at the chosen test locations. It will be eventually set later in checkInferenceParameters, if nonparametric inference is required.}

\item{\code{f_var}}{An integer taking value 1 or 2. If 1 local variance estimates for the nonlinear part of the model will be computed,
whereas if 2 they will not.}

\item{\code{quantile}}{Vector of quantiles needed for confidence intervals, used only if interval is not 0.}

\item{\code{alpha}}{1 minus confidence level vector of sign-flipping approaches confidence intervals. Used only if interval is not 0.}

\item{\code{n_flip}}{An integer representing the number of sign-flips in the case of sign-flipping approaches.}

\item{\code{tol_fspai}}{A real number greater than 0 specifying the tolerance for FSPAI algorithm, in case of non-exact inference (not implemented in this version).}

\item{\code{definition}}{An integer taking value 0 or 1. If set to 1, the class will be considered as created by the function \code{\link{inferenceDataObjectBuilder}},
leading to avoid some of the checks that are performed on inference data within smoothing functions.}
}}

