% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-caps.R
\name{compare_caps}
\alias{compare_caps}
\title{Generates results of multiple clustering strategies}
\usage{
compare_caps(
  x,
  y,
  n_clusters = 1:5,
  metric = c("l2", "pearson"),
  clustering_method = c("kmeans", "hclust-complete", "hclust-average", "hclust-single",
    "dbscan"),
  warping_class = c("affine", "dilation", "none", "shift", "srsf"),
  centroid_type = c("mean", "medoid", "median", "lowess", "poly"),
  cluster_on_phase = FALSE
)
}
\arguments{
\item{x}{A numeric vector of length \eqn{M} or a numeric matrix of shape
\eqn{N \times M} or an object of class \code{\link[funData:funData-class]{funData::funData}}. If a numeric
vector or matrix, it specifies the grid(s) of size \eqn{M} on which each of
the \eqn{N} curves have been observed. If an object of class
\code{\link[funData:funData-class]{funData::funData}}, it contains the whole functional data set and the \code{y}
argument is not used.}

\item{y}{Either a numeric matrix of shape \eqn{N \times M} or a numeric array
of shape \eqn{N \times L \times M} or an object of class \code{\link[fda:fd]{fda::fd}}. If a
numeric matrix or array, it specifies the \eqn{N}-sample of
\eqn{L}-dimensional curves observed on grids of size \eqn{M}. If an object
of class \code{\link[fda:fd]{fda::fd}}, it contains all the necessary information about the
functional data set to be able to evaluate it on user-defined grids.}

\item{n_clusters}{An integer vector specifying a set of clustering partitions
to create. Defaults to \code{1:5}.}

\item{metric}{A string specifying the metric used to compare curves. Choices
are \code{"l2"} or \code{"pearson"}. Defaults to \code{"l2"}. Used only when
\code{warping_class != "srsf"}. For the boundary-preserving warping class, the
L2 distance between the SRSFs of the original curves is used.}

\item{clustering_method}{A character vector specifying one or more clustering
methods to be fit. Choices are \code{"kmeans"}, \code{"hclust-complete"},
\code{"hclust-average"}, \code{"hclust-single"} or \code{"dbscan"}. Defaults to all of
them.}

\item{warping_class}{A character vector specifying one or more classes of
warping functions to use for curve alignment. Choices are \code{"affine"},
\code{"dilation"}, \code{"none"}, \code{"shift"} or \code{"srsf"}. Defaults to all of them.}

\item{centroid_type}{A character vector specifying one or more ways to
compute centroids. Choices are \code{"mean"}, \code{"medoid"}, \code{"median"}, \code{"lowess"}
or \code{"poly"}. Defaults to all of them.}

\item{cluster_on_phase}{A boolean specifying whether clustering should be
based on phase variation or amplitude variation. Defaults to \code{FALSE} which
implies amplitude variation.}
}
\value{
An object of class \code{mcaps} which is a \code{\link[tibble:tibble]{tibble::tibble}} storing the
objects of class \code{\link{caps}} in correspondence of each combination of possible
choices from the input arguments.
}
\description{
This function searches for clusters in the input data set using different
strategies and generates an object of class \code{mcaps} which stores multiple
objects of class \code{\link{caps}}. This is a helper function to facilitate comparison
of clustering methods and choice of an \emph{optimal} one.
}
\examples{
#----------------------------------
# Compare k-means results with k = 1, 2, 3, 4, 5 using mean centroid and
# various warping classes.
\dontrun{
sim30_mcaps <- compare_caps(
  x = simulated30_sub$x,
  y = simulated30_sub$y,
  warping_class = c("none", "shift", "dilation", "affine"),
  clustering_method = "kmeans",
  centroid_type = "mean"
)
}

#----------------------------------
# Then visualize the results
# Either with ggplot2 via ggplot2::autoplot(sim30_mcaps)
# or using graphics::plot()
# You can visualize the WSS values:
plot(sim30_mcaps, validation_criterion = "wss", what = "mean")
plot(sim30_mcaps, validation_criterion = "wss", what = "distribution")
# Or the average silhouette values:
plot(sim30_mcaps, validation_criterion = "silhouette", what = "mean")
plot(sim30_mcaps, validation_criterion = "silhouette", what = "distribution")
}
