% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertSupport.R
\name{ConvertSupport}
\alias{ConvertSupport}
\title{Convert support of a mu/phi/cov etc. to and from obsGrid and workGrid}
\usage{
ConvertSupport(fromGrid, toGrid, mu = NULL, Cov = NULL, phi = NULL)
}
\arguments{
\item{fromGrid}{vector of points with input grid to interpolate from}

\item{toGrid}{vector of points with the target grid to interpolate on}

\item{mu}{any vector of function to be interpolated}

\item{Cov}{a square matrix supported on fromGrid * fromGrid, to be interpolated to toGrid * toGrid.}

\item{phi}{any matrix, each column containing a function to be interpolated}
}
\description{
Convert the support of a given function 1-D or 2-D function from 'fromGrd' to 'toGrid'.
Both grids need to be sorted. This is a interpolation/convenience function.
}

