% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPCAder.R
\name{FPCAder}
\alias{FPCAder}
\title{Obtain the derivatives of eigenfunctions/ eigenfunctions of derivatives
(note: these two are not the same)}
\usage{
FPCAder(fpcaObj, derOptns = list(p = 1))
}
\arguments{
\item{fpcaObj}{A object of class FPCA returned by the function FPCA().}

\item{derOptns}{A list of options to control the derivation parameters specified by \code{list(name=value)}. See `Details'. (default = NULL)}
}
\description{
Obtain the derivatives of eigenfunctions/ eigenfunctions of derivatives
(note: these two are not the same)
}
\details{
Available derivative options are 
\describe{
\item{method}{The method used for obtaining the derivatives -- default is  'FPC', which is the derivatives of eigenfunctions; 'DPC': eigenfunctions of derivatives, 
with G^(1,1) estimated by an initial kernel local smoothing step for  G^(1,0),  then applying a 1D smoother in the second direction; 
'FPC': functional principal component, based on smoothing the eigenfunctions; 'FPC1': functional principal component, based on smoothing G^(1,0). 
 The latter may produce better estimates than 'FPC' but is slower.}
\item{p}{The order of the derivatives returned (default: 1, max: 2). }
\item{bw}{Bandwidth for the 1D and the 2D smoothers (default: p * 0.1 * S, where S is the length of the domain).}
\item{kernelType}{Smoothing kernel choice; same available types are FPCA(). default('epan')}
}
}
\examples{

bw <- 0.2
kern <- 'epan'
set.seed(1)
n <- 50 
M <- 30
pts <- seq(0, 1, length.out=M)
lambdaTrue <- c(1, 0.8, 0.1)^2
sigma2 <- 0.1

samp2 <- MakeGPFunctionalData(n, M, pts, K=length(lambdaTrue), 
                              lambda=lambdaTrue, sigma=sqrt(sigma2), basisType='legendre01')
samp2 <- c(samp2, MakeFPCAInputs(tVec=pts, yVec=samp2$Yn))
fpcaObj <- FPCA(samp2$Ly, samp2$Lt, list(methodMuCovEst='smooth',
                userBwCov=bw, userBwMu=bw, kernel=kern, error=TRUE)) 
CreatePathPlot(fpcaObj, showObs=FALSE)

FPCoptn <- list(bw=bw, kernelType=kern, method='FPC')
DPCoptn <- list(bw=bw, kernelType=kern, method='DPC')
FPC <- FPCAder(fpcaObj, FPCoptn)
DPC <- FPCAder(fpcaObj, DPCoptn)

CreatePathPlot(FPC, ylim=c(-5, 10))
CreatePathPlot(DPC, ylim=c(-5, 10))

# Get the true derivatives
phi <-  CreateBasis(K=3, type='legendre01', pts=pts)
basisDerMat <- apply(phi, 2, function(x) 
                       ConvertSupport(seq(0, 1, length.out=M - 1), pts, diff(x) * (M - 1)))
trueDer <- matrix(1, n, M, byrow=TRUE) + tcrossprod(samp2$xi, basisDerMat)
matplot(t(trueDer), type='l', ylim=c(-5, 10))

# DPC is slightly better in terms of RMSE
mean((fitted(FPC) - trueDer)^2)
mean((fitted(DPC) - trueDer)^2)

}
\references{
\cite{Dai, X., Tao, W., Müller, H.G. (2018). Derivative principal components for representing the time dynamics of longitudinal and functional data.
 Statistica Sinica 28, 1583--1609. (DPC)}
\cite{Liu, Bitao, and Hans-Georg Müller. "Estimating derivatives for samples of sparsely observed functions, 
with application to online auction dynamics." Journal of the American Statistical Association 104, no. 486 (2009): 704-717. (FPC)}
}
