% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_warping.R
\name{time_warping}
\alias{time_warping}
\title{Group-wise function alignment}
\usage{
time_warping(f, time, lambda = 0, method = "mean", showplot = TRUE,
  smooth_data = FALSE, sparam = 25, parallel = FALSE, omethod = "DP",
  MaxItr = 20)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{lambda}{controls the elasticity (default = 0)}

\item{method}{warp and calculate to Karcher Mean or Median (options = "mean"
or "median", default = "mean")}

\item{showplot}{shows plots of functions (default = T)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{parallel}{enable parallel mode using \code{\link{foreach}} and
\code{doParallel} package (default=F)}

\item{omethod}{optimization method (DP,DP2,RBFGS)}

\item{MaxItr}{maximum number of iterations}
}
\value{
Returns a fdawarp object containing \item{f0}{original functions}
\item{fn}{aligned functions - matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}
\item{qn}{aligned SRSFs - similar structure to fn}
\item{q0}{original SRSF - similar structure to fn}
\item{fmean}{function mean or median - vector of length \eqn{N}}
\item{mqn}{SRSF mean or median - vector of length \eqn{N}}
\item{gam}{warping functions - similar structure to fn}
\item{orig.var}{Original Variance of Functions}
\item{amp.var}{Amplitude Variance}
\item{phase.var}{Phase Variance}
\item{qun}{Cost Function Value}
}
\description{
This function aligns a collection of functions using the elastic square-root
slope (srsf) framework.
}
\examples{
data("simu_data")
# use more iterations for accuracy
out = time_warping(simu_data$f,simu_data$time, MaxItr=1)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srsf}
