% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{GRADIENTBOOSTING}
\alias{GRADIENTBOOSTING}
\title{Classification using Gradient Boosting}
\usage{
GRADIENTBOOSTING(train, labels, ntree = 500, learningrate = 0.3,
  tune = FALSE, ...)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{ntree}{The number of trees in the forest.}

\item{learningrate}{The learning rate (between 0 and 1).}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other parameters.}
}
\value{
The classification model.
}
\description{
This function builds a classification model using Gradient Boosting
}
\examples{
require (datasets)
data (iris)
GRADIENTBOOSTING (iris [, -5], iris [, 5])
}
\seealso{
\code{\link[xgboost]{xgboost}}
}
