% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{SVMl}
\alias{SVMl}
\title{Classification using Support Vector Machine with a linear kernel}
\usage{
SVMl(train, labels, cost = 2^(-3:3), params = NULL, tune = FALSE,
  ...)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{cost}{The cost parameter (if a vector, cross-over validation is used to chose the best size).}

\item{params}{Object containing the parameters. If given, it replaces \code{gamma} and \code{cost}.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other arguments.}
}
\value{
The classification model.
}
\description{
This function builds a classification model using Support Vector Machine with a linear kernel.
}
\examples{
require (datasets)
data (iris)
SVMl (iris [, -5], iris [, 5], cost = 1)
}
\seealso{
\code{\link[e1071]{svm}}, \code{\link{SVM}}
}
