% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\docType{data}
\name{cookies}
\alias{cookies}
\alias{cookies.desc.train}
\alias{cookies.desc.test}
\alias{cookies.y.train}
\alias{cookies.y.test}
\title{Cookies dataset}
\format{The cookies.desc.* datasets contains the 700 columns that correspond to the NIR reflectance spectrum.
The cookies.y.* datasets contains four columns that correspond to the four constituents fat, sucrose, dry flour, and water.
The cookies.*.train contains 40 rows that correspond to the calibration data.
The cookies.*.test contains 32 rows that correspond to the prediction data.}
\source{
P. J. Brown and T. Fearn and M. Vannucci (2001) "Bayesian wavelet regression on curves with applications to a spectroscopic calibration problem", Journal of the American Statistical Association, 96(454), pp. 398-408.
}
\usage{
cookies
cookies.desc.train
cookies.desc.test
cookies.y.train
cookies.y.test
}
\description{
This data set contains measurements from quantitative NIR spectroscopy.
The example studied arises from an experiment done to test the feasibility of NIR spectroscopy to measure the composition of biscuit dough pieces (formed but unbaked biscuits).
Two similar sample sets were made up, with the standard recipe varied to provide a large range for each of the four constituents under investigation: fat, sucrose, dry flour, and water.
The calculated percentages of these four ingredients represent the 4 responses.
There are 40 samples in the calibration or training set (with sample 23 being an outlier).
There are a further 32 samples in the separate prediction or validation set (with example 21 considered as an outlier).
An NIR reflectance spectrum is available for each dough piece.
The spectral data consist of 700 points measured from 1100 to 2498 nanometers (nm) in steps of 2 nm.
}
\seealso{
\code{\link[fds]{labp}}, \code{\link[fds]{labc}}, \code{\link[fds]{nirp}}, \code{\link[fds]{nirc}}
}
