% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{predict.model}
\alias{predict.model}
\title{Model predictions}
\usage{
\method{predict}{model}(object, test, fuzzy = FALSE, ...)
}
\arguments{
\item{object}{The classification model (of class \code{\link{cda-class}}, created by \code{\link{CDA}}).}

\item{test}{The test set (a \code{data.frame}).}

\item{fuzzy}{A boolean indicating whether fuzzy classification is used or not.}

\item{...}{Other parameters.}
}
\value{
A vector of predicted values (\code{factor}).
}
\description{
This function predicts values based upon a model trained by any classification or regression model.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = LDA (d$train.x, d$train.y)
predict (model, d$test.x)
}
\seealso{
\code{\link{model-class}}
}
