% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{decisiontree}
\alias{decisiontree}
\title{Decision tree
Trains a decision on the given training dataset and uses it to predict classification for test dataset. The resulting accuracy, sensitivity and specificity are returned, as well as a tree summary.}
\usage{
decisiontree(data_train, data_test, includeplot = FALSE, showtree = FALSE)
}
\arguments{
\item{data_train}{Training set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model is trained.}

\item{data_test}{Test set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model in tested.}

\item{includeplot}{Show performance scatter plot (default:FALSE)}

\item{showtree}{Show trained decision tree graphically (default:FALSE)}
}
\value{
List containing performance summary, accessed using training (training accuracy), test (test accuracy), trainsensitivity, testsensitivity, trainspecificity, testspecificity. Also accessed using fit is the trained model produced. This can be used to find the features which appear at each level of the tree.
}
\description{
Decision tree
Trains a decision on the given training dataset and uses it to predict classification for test dataset. The resulting accuracy, sensitivity and specificity are returned, as well as a tree summary.
}
\examples{
data_train = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,0,0,1,1)),
      A=c(1,1,1,0,0,0,1,1,1,0),
      B=c(0,1,1,0,1,1,0,1,1,0),
      C=c(0,0,1,0,0,1,0,0,1,0))
data_test = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,1,0)),
      A=c(0,0,0,1,0,0,0,1),
      B=c(1,1,1,0,0,1,1,1),
      C=c(0,0,1,1,0,0,1,1))
decisiontree(data_train,data_test)
}
\keyword{classification}
\keyword{decision}
\keyword{dtree}
\keyword{tree}
