% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_lag}
\alias{gg_lag}
\title{Lag plots}
\usage{
gg_lag(
  data,
  y = NULL,
  period = NULL,
  lags = 1:9,
  geom = c("path", "point"),
  arrow = FALSE,
  ...
)
}
\arguments{
\item{data}{A tidy time series object (tsibble)}

\item{y}{The variable to plot (a bare expression). If NULL, it will
automatically selected from the data.}

\item{period}{The seasonal period to display.}

\item{lags}{A vector of lags to display as facets.}

\item{geom}{The geometry used to display the data.}

\item{arrow}{Arrow specification to show the direction in the lag path. If
TRUE, an appropriate default arrow will be used. Alternatively, a user
controllable arrow created with \code{\link[grid:arrow]{grid::arrow()}} can be used.}

\item{...}{Additional arguments passed to the geom.}
}
\value{
A ggplot object showing a lag plot of a time series.
}
\description{
A lag plot shows the time series against lags of itself. It is often coloured
the seasonal period to identify how each season correlates with others.
}
\examples{
library(tsibble)
library(dplyr)
tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  gg_lag(Turnover)

}
